/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.grn.GRN;
import org.graylog.security.Capability;
import org.graylog.security.events.AutoValue_EntitySharesUpdateEvent;
import org.graylog.security.events.AutoValue_EntitySharesUpdateEvent_Share;
import org.graylog2.plugin.database.users.User;

@JsonAutoDetect
@AutoValue
public abstract class EntitySharesUpdateEvent {
    public abstract User user();

    public abstract GRN entity();

    public abstract ImmutableList<Share> creates();

    public abstract ImmutableList<Share> deletes();

    public abstract ImmutableList<Share> updates();

    public static EntitySharesUpdateEvent create(User user, GRN entity, List<Share> creates, List<Share> deletes, List<Share> updates) {
        return EntitySharesUpdateEvent.builder().user(user).entity(entity).creates(creates).deletes(deletes).updates(updates).build();
    }

    public static Builder builder() {
        return new AutoValue_EntitySharesUpdateEvent.Builder();
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class Share {
        public abstract GRN grantee();

        public abstract Capability capability();

        public abstract Optional<Capability> formerCapability();

        public static Share create(GRN grantee, Capability capability, @Nullable Capability formerCapability) {
            return new AutoValue_EntitySharesUpdateEvent_Share(grantee, capability, Optional.ofNullable(formerCapability));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract ImmutableList.Builder<Share> createsBuilder();

        public abstract ImmutableList.Builder<Share> deletesBuilder();

        public abstract ImmutableList.Builder<Share> updatesBuilder();

        public abstract Builder user(User var1);

        public abstract Builder entity(GRN var1);

        public Builder addCreates(GRN grantee, Capability capability) {
            this.createsBuilder().add((Object)Share.create(grantee, capability, null));
            return this;
        }

        public Builder addDeletes(GRN grantee, Capability capability) {
            this.deletesBuilder().add((Object)Share.create(grantee, capability, null));
            return this;
        }

        public Builder addUpdates(GRN grantee, Capability capability, Capability formerCapability) {
            this.updatesBuilder().add((Object)Share.create(grantee, capability, formerCapability));
            return this;
        }

        public abstract Builder creates(List<Share> var1);

        public abstract Builder deletes(List<Share> var1);

        public abstract Builder updates(List<Share> var1);

        public abstract EntitySharesUpdateEvent build();
    }
}

