/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.constraints;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.vdurmont.semver4j.Requirement;
import org.graylog2.contentpacks.model.constraints.AutoValue_PluginVersionConstraint;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.Version;

@JsonDeserialize(builder=AutoValue_PluginVersionConstraint.Builder.class)
@AutoValue
public abstract class PluginVersionConstraint
implements Constraint {
    static final String TYPE_NAME = "plugin-version";
    static final String FIELD_PLUGIN_ID = "plugin";
    static final String FIELD_PLUGIN_VERSION = "version";

    @JsonProperty(value="plugin")
    public abstract String pluginId();

    @JsonProperty(value="version")
    public abstract Requirement version();

    public abstract Builder toBuilder();

    public static PluginVersionConstraint of(PluginMetaData pluginMetaData) {
        Version version = pluginMetaData.getVersion();
        String versionString = version.toString().replace("-SNAPSHOT", "");
        Requirement requirement = Requirement.buildNPM((String)(">=" + versionString));
        return PluginVersionConstraint.builder().pluginId(pluginMetaData.getUniqueId()).version(requirement).build();
    }

    public static Builder builder() {
        return new AutoValue_PluginVersionConstraint.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements Constraint.ConstraintBuilder<Builder> {
        @JsonProperty(value="plugin")
        public abstract Builder pluginId(String var1);

        @JsonProperty(value="version")
        public abstract Builder version(Requirement var1);

        @JsonIgnore
        public Builder version(String versionExpression) {
            Requirement requirement = Requirement.buildNPM((String)versionExpression);
            return this.version(requirement);
        }

        abstract PluginVersionConstraint autoBuild();

        public PluginVersionConstraint build() {
            this.type(PluginVersionConstraint.TYPE_NAME);
            return this.autoBuild();
        }
    }
}

