/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.model.entities.$AutoValue_ViewEntity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchEntity;
import org.graylog2.contentpacks.model.entities.ViewStateEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ViewEntity
implements NativeEntityConverter<ViewDTO.Builder> {
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_SUMMARY = "summary";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_SEARCH = "search";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_REQUIRES = "requires";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_OWNER = "owner";

    @JsonProperty(value="type")
    public abstract Type type();

    @JsonProperty(value="title")
    @NotBlank
    public abstract ValueReference title();

    @JsonProperty(value="summary")
    public abstract ValueReference summary();

    @JsonProperty(value="description")
    public abstract ValueReference description();

    @JsonProperty(value="search")
    public abstract SearchEntity search();

    @JsonProperty(value="properties")
    public abstract ImmutableSet<String> properties();

    @JsonProperty(value="requires")
    public abstract Map<String, PluginMetadataSummary> requires();

    @JsonProperty(value="state")
    public abstract Map<String, ViewStateEntity> state();

    @JsonProperty(value="owner")
    public abstract Optional<String> owner();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    public ViewDTO.Type dtoType() {
        switch (this.type()) {
            case SEARCH: {
                return ViewDTO.Type.SEARCH;
            }
            case DASHBOARD: {
                return ViewDTO.Type.DASHBOARD;
            }
        }
        throw new IllegalArgumentException("Unsupported view type:" + (Object)((Object)this.type()));
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public ViewDTO.Builder toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        ViewDTO.Builder viewBuilder = ViewDTO.builder().title(this.title().asString(parameters)).summary(this.summary().asString(parameters)).description(this.description().asString(parameters)).type(this.dtoType()).properties((Set<String>)this.properties()).createdAt(this.createdAt()).requires(this.requires());
        if (this.owner().isPresent()) {
            viewBuilder.owner(this.owner().get());
        }
        return viewBuilder;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="type")
        public abstract Builder type(Type var1);

        public Builder type(ViewDTO.Type type) {
            switch (type) {
                case SEARCH: {
                    this.type(Type.SEARCH);
                    break;
                }
                case DASHBOARD: {
                    this.type(Type.DASHBOARD);
                }
            }
            return this;
        }

        @JsonProperty(value="title")
        public abstract Builder title(ValueReference var1);

        @JsonProperty(value="summary")
        public abstract Builder summary(ValueReference var1);

        @JsonProperty(value="description")
        public abstract Builder description(ValueReference var1);

        @JsonProperty(value="search")
        public abstract Builder search(SearchEntity var1);

        abstract ImmutableSet.Builder<String> propertiesBuilder();

        @JsonProperty(value="properties")
        public Builder properties(Set<String> properties) {
            this.propertiesBuilder().addAll(properties);
            return this;
        }

        @JsonProperty(value="requires")
        public abstract Builder requires(Map<String, PluginMetadataSummary> var1);

        @JsonProperty(value="owner")
        public abstract Builder owner(@Nullable String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        @JsonProperty(value="state")
        public abstract Builder state(Map<String, ViewStateEntity> var1);

        @JsonCreator
        public static Builder create() {
            return new $AutoValue_ViewEntity.Builder().type(Type.DASHBOARD).summary(ValueReference.of("")).description(ValueReference.of("")).properties((Set<String>)ImmutableSet.of()).requires(Collections.emptyMap()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC));
        }

        public abstract ViewEntity build();
    }

    public static enum Type {
        SEARCH,
        DASHBOARD;

    }
}

