/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.system;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeIdPersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeId {
    private static final Logger LOG = LoggerFactory.getLogger(NodeId.class);
    private final String filename;
    private final String id;

    public NodeId(String filename) {
        this.filename = filename;
        this.id = this.readOrGenerate();
    }

    private String readOrGenerate() {
        try {
            String read = this.read();
            if (read == null || read.isEmpty()) {
                return this.generate();
            }
            LOG.info("Node ID: {}", (Object)read);
            return read;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return this.generate();
        }
        catch (Exception e2) {
            String msg = "Could not read or generate node ID!";
            LOG.debug("Could not read or generate node ID!", (Throwable)e2);
            throw new NodeIdPersistenceException("Could not read or generate node ID!", e2);
        }
    }

    private String read() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(this.filename, new String[0]), StandardCharsets.UTF_8);
        return lines.size() > 0 ? lines.get(0) : "";
    }

    private String generate() throws NodeIdPersistenceException {
        String generated = Tools.generateServerId();
        LOG.info("No node ID file found. Generated: {}", (Object)generated);
        try {
            this.persist(generated);
        }
        catch (IOException e1) {
            LOG.debug("Could not persist node ID: ", (Throwable)e1);
            throw new NodeIdPersistenceException("Unable to persist node ID", e1);
        }
        return generated;
    }

    private void persist(String nodeId) throws IOException {
        FileUtils.writeStringToFile((File)new File(this.filename), (String)nodeId, (Charset)StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.id;
    }

    public String toEscapedString() {
        return this.id.replace("\\", "\\\\").replace("$", "\\u0024").replace(".", "\\u002e");
    }

    public String toUnescapedString() {
        return this.id.replace("\\u002e", ".").replace("\\u0024", "$").replace("\\\\", "\\");
    }

    public String anonymize() {
        return Hashing.sha256().hashString((CharSequence)this.id, StandardCharsets.UTF_8).toString();
    }

    public String getShortNodeId() {
        return this.id.split("-")[0];
    }
}

