/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.PositiveOrZero;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.SearchExecutor;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.resources.search.SearchResource;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Legacy/Search/Relative", description="Message search", tags={"cloud"})
@Path(value="/search/universal/relative")
public class RelativeSearchResource
extends SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(RelativeSearchResource.class);

    @Inject
    public RelativeSearchResource(Searches searches, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor, SearchExecutor searchExecutor) {
        super(searches, clusterConfigService, decoratorProcessor, searchExecutor);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with relative timerange.", notes="Search for messages in a relative timerange, specified as seconds from now. Example: 300 means search from 5 minutes ago to now.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public SearchResponse searchRelative(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="limit", value="Maximum number of messages to return.") @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset") @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter") @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return") @QueryParam(value="fields") String fields, @ApiParam(name="sort", value="Sorting (field:asc / field:desc)") @QueryParam(value="sort") String sort, @ApiParam(name="decorate", value="Run decorators on search result") @QueryParam(value="decorate") @DefaultValue(value="true") boolean decorate, @Context SearchUser searchUser) {
        this.checkSearchPermission(filter, "searches:relative");
        List<String> fieldList = this.parseOptionalFields(fields);
        Sort sorting = this.buildSortOrder(sort);
        TimeRange timeRange = this.buildRelativeTimeRange(range);
        return this.search(query, limit, offset, filter, decorate, searchUser, fieldList, sorting, timeRange);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with relative timerange.", notes="Search for messages in a relative timerange, specified as seconds from now. Example: 300 means search from 5 minutes ago to now.")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public ChunkedOutput<ScrollResult.ScrollChunk> searchRelativeChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="batch_size", value="Batch size for the backend storage export request.", required=false) @QueryParam(value="batch_size") @DefaultValue(value="500") int batchSize, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") @NotEmpty String fields) {
        this.checkSearchPermission(filter, "searches:relative");
        List<String> fieldList = this.parseFields(fields);
        TimeRange timeRange = this.buildRelativeTimeRange(range);
        ScrollResult scroll = this.searches.scroll(query, timeRange, limit, offset, fieldList, filter, batchSize);
        return this.buildChunkedOutput(scroll);
    }

    @GET
    @Path(value="/export")
    @Timed
    @ApiOperation(value="Export message search with relative timerange.", notes="Search for messages in a relative timerange, specified as seconds from now. Example: 300 means search from 5 minutes ago to now.")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public Response exportSearchRelativeChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="batch_size", value="Batch size for the backend storage export request.", required=false) @QueryParam(value="batch_size") @DefaultValue(value="500") int batchSize, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") @NotEmpty String fields) {
        this.checkSearchPermission(filter, "searches:relative");
        String filename = "graylog-search-result-relative-" + range + ".csv";
        return Response.ok(this.searchRelativeChunked(query, range, limit, offset, batchSize, filter, fields)).header("Content-Disposition", (Object)("attachment; filename=" + filename)).build();
    }

    private TimeRange buildRelativeTimeRange(int range) {
        try {
            return this.restrictTimeRange(RelativeRange.create(range));
        }
        catch (InvalidRangeParametersException e) {
            LOG.warn("Invalid timerange parameters provided. Returning HTTP 400.");
            throw new BadRequestException((Throwable)e);
        }
    }
}

