/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.inputs.extractors.SplitAndIndexExtractor;
import org.graylog2.rest.models.tools.requests.SplitAndIndexTestRequest;
import org.graylog2.rest.models.tools.responses.SplitAndIndexTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/split_and_index_tester")
public class SplitAndIndexTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public SplitAndIndexTesterResponse splitAndIndexTester(@QueryParam(value="split_by") @NotNull String splitBy, @QueryParam(value="index") @Min(value=0L) @Min(value=0L) int index, @QueryParam(value="string") @NotNull String string) {
        return this.doSplitAndIndexTest(string, splitBy, index);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test split and index extractor")
    public SplitAndIndexTesterResponse splitAndIndexTest(@Valid @NotNull SplitAndIndexTestRequest splitAndIndexTestRequest) {
        return this.doSplitAndIndexTest(splitAndIndexTestRequest.string(), splitAndIndexTestRequest.splitBy(), splitAndIndexTestRequest.index());
    }

    private SplitAndIndexTesterResponse doSplitAndIndexTest(String string, String splitBy, int index) {
        String cut = SplitAndIndexExtractor.cut(string, splitBy, index - 1);
        int[] positions = SplitAndIndexExtractor.getCutIndices(string, splitBy, index - 1);
        return SplitAndIndexTesterResponse.create(cut != null, cut, positions[0], positions[1]);
    }
}

