/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.documentation;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.graylog2.Configuration;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/api-browser")
public class DocumentationBrowserResource
extends RestResource {
    private final MimetypesFileTypeMap mimeTypes;
    private final HttpConfiguration httpConfiguration;
    private final ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    private final Engine templateEngine;
    private final Configuration configuration;

    @Inject
    public DocumentationBrowserResource(MimetypesFileTypeMap mimeTypes, HttpConfiguration httpConfiguration, Engine templateEngine, Configuration configuration) {
        this.mimeTypes = Objects.requireNonNull(mimeTypes, "mimeTypes");
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration, "httpConfiguration");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
        this.configuration = configuration;
    }

    @GET
    public Response root(@Context HttpHeaders httpHeaders) throws IOException {
        String index = this.index(httpHeaders);
        return Response.ok((Object)index, (MediaType)MediaType.TEXT_HTML_TYPE).header("Content-Length", (Object)index.length()).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="index.html")
    public String index(@Context HttpHeaders httpHeaders) throws IOException {
        URL templateUrl = this.getClass().getResource("/swagger/index.html.template");
        String template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        ImmutableMap model = ImmutableMap.of((Object)"baseUri", (Object)this.httpConfiguration.getHttpPublishUri().resolve("api/").toString(), (Object)"globalModePath", (Object)"", (Object)"globalUriMarker", (Object)"", (Object)"showWarning", (Object)"");
        return this.templateEngine.transform(template, (Map)model);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/global/index.html")
    public String allIndex(@Context HttpHeaders httpHeaders) throws IOException {
        URL templateUrl = this.getClass().getResource("/swagger/index.html.template");
        String template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        URI relativePath = RestTools.buildRelativeExternalUri((MultivaluedMap<String, String>)httpHeaders.getRequestHeaders(), this.httpConfiguration.getHttpExternalUri());
        ImmutableMap model = ImmutableMap.of((Object)"baseUri", (Object)relativePath.resolve("api/").toString(), (Object)"globalModePath", (Object)"global/index.html", (Object)"globalUriMarker", (Object)"/global", (Object)"showWarning", (Object)"true", (Object)"isCloud", (Object)(this.configuration.isCloud() ? "true" : ""));
        return this.templateEngine.transform(template, (Map)model);
    }

    @GET
    @Path(value="/{route: .*}")
    public Response asset(@PathParam(value="route") String route) throws IOException {
        if (route.startsWith("global/")) {
            route = route.replaceFirst("global/", "");
        }
        if (route.contains("..")) {
            throw new BadRequestException("Not allowed to access parent directory");
        }
        URL resource = this.classLoader.getResource("swagger/" + route);
        if (null != resource) {
            try {
                byte[] resourceBytes = Resources.toByteArray((URL)resource);
                return Response.ok((Object)resourceBytes, (String)this.mimeTypes.getContentType(route)).header("Content-Length", (Object)resourceBytes.length).build();
            }
            catch (IOException e) {
                throw new NotFoundException("Couldn't load " + resource, (Throwable)e);
            }
        }
        throw new NotFoundException("Couldn't find " + route);
    }
}

