/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationException;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.NotificationTestData;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog2.plugin.database.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationResourceHandler.class);
    private final DBNotificationService notificationService;
    private final DBJobDefinitionService jobDefinitionService;
    private final DBEventDefinitionService eventDefinitionService;
    private final Map<String, EventNotification.Factory> eventNotificationFactories;

    @Inject
    public NotificationResourceHandler(DBNotificationService notificationService, DBJobDefinitionService jobDefinitionService, DBEventDefinitionService eventDefinitionService, Map<String, EventNotification.Factory> eventNotificationFactories) {
        this.notificationService = notificationService;
        this.jobDefinitionService = jobDefinitionService;
        this.eventDefinitionService = eventDefinitionService;
        this.eventNotificationFactories = eventNotificationFactories;
    }

    public NotificationDto create(NotificationDto unsavedDto, Optional<User> user) {
        NotificationDto dto;
        if (user.isPresent()) {
            dto = this.notificationService.saveWithOwnership(unsavedDto, user.get());
            LOG.debug("Created notification definition <{}/{}> with user <{}>", new Object[]{dto.id(), dto.title(), user.get()});
        } else {
            dto = this.notificationService.save(unsavedDto);
            LOG.debug("Created notification definition <{}/{}> without user", (Object)dto.id(), (Object)dto.title());
        }
        try {
            JobDefinitionDto unsavedJobDefinition = JobDefinitionDto.builder().title(dto.title()).description(dto.description()).config(this.getSchedulerConfig(dto.id())).build();
            JobDefinitionDto jobDefinition = this.jobDefinitionService.save(unsavedJobDefinition);
            LOG.debug("Created scheduler job definition <{}/{}> for notification <{}/{}>", new Object[]{jobDefinition.id(), jobDefinition.title(), dto.id(), dto.title()});
        }
        catch (Exception e) {
            LOG.error("Failed to create job definition for notification <{}/{}>", new Object[]{dto.id(), dto.title(), e});
            throw e;
        }
        return dto;
    }

    public NotificationDto update(NotificationDto updatedDto) {
        Optional oldDto = this.notificationService.get(updatedDto.id());
        NotificationDto dto = this.notificationService.save(updatedDto);
        LOG.debug("Updated notification definition <{}/{}>", (Object)dto.id(), (Object)dto.title());
        try {
            JobDefinitionDto oldJobDefinition = this.jobDefinitionService.getByConfigField("notification_id", updatedDto.id()).orElseThrow(() -> new IllegalStateException("Couldn't find job definition for notification definition <" + updatedDto.id() + ">"));
            JobDefinitionDto unsavedJobDefinition = oldJobDefinition.toBuilder().title(dto.title()).description(dto.description()).config(this.getSchedulerConfig(dto.id())).build();
            JobDefinitionDto jobDefinition = this.jobDefinitionService.save(unsavedJobDefinition);
            LOG.debug("Updated scheduler job definition <{}/{}> for notification <{}/{}>", new Object[]{jobDefinition.id(), jobDefinition.title(), dto.id(), dto.title()});
        }
        catch (Exception e) {
            LOG.error("Reverting to old notification definition <{}/{}> because of an error updating the job definition", new Object[]{dto.id(), dto.title(), e});
            oldDto.ifPresent(this.notificationService::save);
            throw e;
        }
        return dto;
    }

    public boolean delete(String dtoId) {
        Optional dto = this.notificationService.get(dtoId);
        if (!dto.isPresent()) {
            return false;
        }
        this.jobDefinitionService.getByConfigField("notification_id", dtoId).ifPresent(jobDefinition -> {
            LOG.debug("Deleting job definition <{}/{}> for notification <{}/{}>", new Object[]{jobDefinition.id(), jobDefinition.title(), ((NotificationDto)dto.get()).id(), ((NotificationDto)dto.get()).title()});
            this.jobDefinitionService.delete(jobDefinition.id());
        });
        this.eventDefinitionService.getByNotificationId(dtoId).forEach(eventDefinition -> {
            LOG.debug("Removing notification <{}/{}> from event definition <{}/{}>", new Object[]{((NotificationDto)dto.get()).id(), ((NotificationDto)dto.get()).title(), eventDefinition.id(), eventDefinition.title()});
            ImmutableList notifications = (ImmutableList)eventDefinition.notifications().stream().filter(entry -> !entry.notificationId().equals(dtoId)).collect(ImmutableList.toImmutableList());
            EventDefinitionDto updatedEventDto = eventDefinition.toBuilder().notifications((ImmutableList<EventNotificationHandler.Config>)notifications).build();
            this.eventDefinitionService.save(updatedEventDto);
        });
        LOG.debug("Deleting notification definition <{}/{}>", (Object)((NotificationDto)dto.get()).id(), (Object)((NotificationDto)dto.get()).title());
        return this.notificationService.delete(dtoId) > 0;
    }

    public void test(NotificationDto notificationDto, String userName) throws NotFoundException, InternalServerErrorException {
        EventNotification.Factory eventNotificationFactory = this.eventNotificationFactories.get(notificationDto.config().type());
        if (eventNotificationFactory == null) {
            throw new NotFoundException("Couldn't find factory for notification type <" + notificationDto.config().type() + ">");
        }
        EventNotificationContext notificationContext = NotificationTestData.getDummyContext(notificationDto, userName);
        Object eventNotification = eventNotificationFactory.create();
        try {
            eventNotification.execute(notificationContext);
        }
        catch (EventNotificationException e) {
            if (e.getCause() != null) {
                throw new InternalServerErrorException(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    private EventNotificationExecutionJob.Config getSchedulerConfig(String notificationId) {
        return EventNotificationExecutionJob.Config.builder().notificationId(notificationId).build();
    }
}

