/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.engine.SearchConfig;
import org.graylog.plugins.views.search.errors.IllegalTimeRangeException;
import org.graylog.plugins.views.search.errors.QueryError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public interface QueryBackend<T extends GeneratedQueryContext> {
    public T generate(SearchJob var1, Query var2, SearchConfig var3);

    default public boolean isAllMessages(TimeRange timeRange) {
        return timeRange instanceof RelativeRange && ((RelativeRange)timeRange).isAllMessages();
    }

    default public AbsoluteRange effectiveTimeRangeForResult(Query query, QueryResult queryResult) {
        Optional<AbsoluteRange> effectiveRange;
        TimeRange effectiveTimeRange = query.globalOverride().flatMap(GlobalOverride::timerange).orElse(query.timerange());
        if (this.isAllMessages(effectiveTimeRange) && (effectiveRange = queryResult.searchTypes().values().stream().filter(result -> result instanceof PivotResult).map(result -> ((PivotResult)result).effectiveTimerange()).reduce((prev, next) -> {
            DateTime from = prev.from().compareTo((ReadableInstant)next.from()) < 0 ? prev.from() : next.from();
            DateTime to = prev.to().compareTo((ReadableInstant)next.to()) < 0 ? next.to() : prev.to();
            return AbsoluteRange.create(from, to);
        })).isPresent()) {
            return effectiveRange.get();
        }
        return AbsoluteRange.create(effectiveTimeRange.getFrom(), effectiveTimeRange.getTo());
    }

    default public QueryResult run(SearchJob job, Query query, GeneratedQueryContext generatedQueryContext) {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            QueryExecutionStats.Builder statsBuilder = QueryExecutionStats.builderWithCurrentTime();
            QueryResult result = this.doRun(job, query, generatedQueryContext);
            stopwatch.stop();
            return result.toBuilder().executionStats(statsBuilder.duration(stopwatch.elapsed(TimeUnit.MILLISECONDS)).effectiveTimeRange(this.effectiveTimeRangeForResult(query, result)).build()).build();
        }
        catch (Exception e) {
            QueryError queryError = new QueryError(query, e);
            generatedQueryContext.addError(queryError);
            return QueryResult.failedQueryWithError(query, queryError);
        }
    }

    public QueryResult doRun(SearchJob var1, Query var2, T var3);

    default public Optional<SearchTypeError> validateSearchType(Query query, SearchType searchType, SearchConfig searchConfig) {
        return searchConfig.getQueryTimeRangeLimit().flatMap(configuredTimeLimit -> searchType.timerange().map(tr -> tr.effectiveTimeRange(query, searchType)).filter(tr -> this.isOutOfLimit((TimeRange)tr, (Period)configuredTimeLimit)).map(tr -> new SearchTypeError(query, searchType.id(), "Search type '" + searchType.type() + "' out of allowed time range limit")));
    }

    default public boolean isOutOfLimit(TimeRange timeRange, Period limit) {
        DateTime start = timeRange.getFrom();
        DateTime end = timeRange.getTo();
        DateTime allowedStart = end.minus((ReadablePeriod)limit);
        return start.isBefore((ReadableInstant)allowedStart);
    }

    default public boolean isSearchTypeWithError(T queryContext, String searchTypeId) {
        return queryContext.errors().stream().filter(q -> q instanceof SearchTypeError).map(q -> (SearchTypeError)q).map(SearchTypeError::searchTypeId).anyMatch(id -> Objects.equals(id, searchTypeId));
    }

    default public void validateQueryTimeRange(Query query, SearchConfig config) {
        config.getQueryTimeRangeLimit().flatMap(timeRangeLimit -> Optional.ofNullable(query.timerange()).filter(tr -> tr.getFrom() != null && tr.getTo() != null).filter(tr -> this.isOutOfLimit((TimeRange)tr, (Period)timeRangeLimit))).ifPresent(tr -> {
            throw new IllegalTimeRangeException("Search out of allowed time range limit");
        });
    }
}

