/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.FieldTypesForStreamsRequest;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="FieldTypes", tags={"cloud"})
@Path(value="/views/fields")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FieldTypesResource
extends RestResource
implements PluginRestResource {
    private final MappedFieldTypesService mappedFieldTypesService;

    @Inject
    public FieldTypesResource(MappedFieldTypesService mappedFieldTypesService) {
        this.mappedFieldTypesService = mappedFieldTypesService;
    }

    @GET
    @ApiOperation(value="Retrieve the list of all fields present in the system")
    public Set<MappedFieldTypeDTO> allFieldTypes(@Context SearchUser searchUser) {
        ImmutableSet<String> streams = searchUser.streams().loadAll();
        return this.mappedFieldTypesService.fieldTypesByStreamIds((Collection<String>)streams, RelativeRange.allTime());
    }

    @POST
    @ApiOperation(value="Retrieve the field list of a given set of streams")
    @NoAuditEvent(value="This is not changing any data")
    public Set<MappedFieldTypeDTO> byStreams(FieldTypesForStreamsRequest request, @Context SearchUser searchUser) {
        ImmutableSet<String> streams = searchUser.streams().readableOrAllIfEmpty(request.streams());
        return this.mappedFieldTypesService.fieldTypesByStreamIds((Collection<String>)streams, request.timerange().orElse(RelativeRange.allTime()));
    }
}

