/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.db.SearchJobService;
import org.graylog.plugins.views.search.engine.QueryEngine;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.permissions.StreamPermissions;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SearchExecutor.class);
    private final SearchDomain searchDomain;
    private final SearchJobService searchJobService;
    private final QueryEngine queryEngine;
    private final SearchExecutionGuard executionGuard;
    private final ObjectMapper objectMapper;

    @Inject
    public SearchExecutor(SearchDomain searchDomain, SearchJobService searchJobService, QueryEngine queryEngine, SearchExecutionGuard executionGuard, ObjectMapper objectMapper) {
        this.searchDomain = searchDomain;
        this.searchJobService = searchJobService;
        this.queryEngine = queryEngine;
        this.executionGuard = executionGuard;
        this.objectMapper = objectMapper;
    }

    public SearchJob execute(String searchId, SearchUser searchUser, ExecutionState executionState) {
        return this.searchDomain.getForUser(searchId, searchUser).map(s -> this.execute((Search)s, searchUser, executionState)).orElseThrow(() -> new NotFoundException("No search found with id <" + searchId + ">."));
    }

    public SearchJob execute(Search search, SearchUser searchUser, ExecutionState executionState) {
        Search searchWithStreams = search.addStreamsToQueriesWithoutStreams(() -> searchUser.streams().loadAll());
        Search searchWithExecutionState = searchWithStreams.applyExecutionState(this.objectMapper, (ExecutionState)MoreObjects.firstNonNull((Object)executionState, (Object)ExecutionState.empty()));
        this.authorize(searchWithExecutionState, searchUser);
        SearchJob searchJob = this.queryEngine.execute(this.searchJobService.create(searchWithExecutionState, searchUser.username()));
        try {
            Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOG.error("Error executing search job <{}>", (Object)searchJob.getId(), (Object)e);
            throw new InternalServerErrorException("Error executing search job: " + e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new InternalServerErrorException("Timeout while executing search job");
        }
        catch (Exception e) {
            LOG.error("Other error", (Throwable)e);
            throw e;
        }
        return searchJob;
    }

    private void authorize(Search search, StreamPermissions streamPermissions) {
        this.executionGuard.check(search, streamPermissions::canReadStream);
    }
}

