/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.graylog.security.authservice.;
import org.graylog.security.authservice.AuthServiceBackendConfig;
import org.graylog2.plugin.rest.ValidationResult;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuthServiceBackendDTO {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_DEFAULT_ROLES = "default_roles";
    private static final String FIELD_CONFIG = "config";

    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="title")
    public abstract String title();

    @JsonProperty(value="description")
    public abstract String description();

    @JsonProperty(value="default_roles")
    public abstract Set<String> defaultRoles();

    @NotNull
    @JsonProperty(value="config")
    public abstract AuthServiceBackendConfig config();

    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (StringUtils.isBlank((CharSequence)this.title())) {
            result.addError(FIELD_TITLE, "Title cannot be empty.");
        }
        try {
            this.config().validate(result);
        }
        catch (UnsupportedOperationException e) {
            result.addError(FIELD_CONFIG, "Config type cannot be empty.");
        }
        return result;
    }

    public AuthServiceBackendDTO withId(String id) {
        return this.toBuilder().id(id).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new .AutoValue_AuthServiceBackendDTO.Builder().description("").defaultRoles(Collections.emptySet());
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="default_roles")
        public abstract Builder defaultRoles(Set<String> var1);

        @JsonProperty(value="config")
        public abstract Builder config(AuthServiceBackendConfig var1);

        public abstract AuthServiceBackendDTO build();
    }
}

