/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.cluster.Node;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@CollectionName(value="nodes")
public class NodeImpl
extends PersistedImpl
implements Node {
    protected NodeImpl(Map<String, Object> fields) {
        super(fields);
    }

    protected NodeImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    @Override
    public String getNodeId() {
        return (String)this.fields.get("node_id");
    }

    @Override
    @JsonProperty(value="is_leader")
    public boolean isLeader() {
        return (Boolean)this.fields.get("is_leader");
    }

    @Override
    public String getTransportAddress() {
        return (String)this.fields.get("transport_address");
    }

    @Override
    public DateTime getLastSeen() {
        return new DateTime((long)this.fields.getOrDefault("last_seen", 0).intValue() * 1000L, DateTimeZone.UTC);
    }

    @Override
    public String getShortNodeId() {
        return this.getNodeId().split("-")[0];
    }

    @Override
    public Node.Type getType() {
        if (!this.fields.containsKey("type")) {
            return Node.Type.SERVER;
        }
        return Node.Type.valueOf(this.fields.get("type").toString().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public String getHostname() {
        return (String)this.fields.get("hostname");
    }

    @Override
    @JsonIgnore
    public Map<String, Validator> getValidations() {
        return Collections.emptyMap();
    }

    @Override
    @JsonIgnore
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }
}

