/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster;

import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeImpl;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.system.NodeId;

public class NodeServiceImpl
extends PersistedServiceImpl
implements NodeService {
    private final long pingTimeout;

    @Inject
    public NodeServiceImpl(MongoConnection mongoConnection, Configuration configuration) {
        super(mongoConnection);
        this.pingTimeout = TimeUnit.MILLISECONDS.toSeconds(configuration.getStaleLeaderTimeout());
    }

    @Override
    public String registerServer(String nodeId, boolean isLeader, URI httpPublishUri, String hostname) {
        HashMap fields = Maps.newHashMap();
        fields.put("last_seen", Tools.getUTCTimestamp());
        fields.put("node_id", nodeId);
        fields.put("type", Node.Type.SERVER.toString());
        fields.put("is_leader", isLeader);
        fields.put("transport_address", httpPublishUri.toString());
        fields.put("hostname", hostname);
        try {
            NodeImpl node;
            try {
                String objectId = this.byNodeId(nodeId).getId();
                node = new NodeImpl(new ObjectId(objectId), fields);
            }
            catch (NodeNotFoundException e) {
                node = new NodeImpl(fields);
            }
            return this.save(node);
        }
        catch (ValidationException e) {
            throw new RuntimeException("Validation failed.", e);
        }
    }

    @Override
    public Node byNodeId(String nodeId) throws NodeNotFoundException {
        BasicDBObject query = new BasicDBObject("node_id", (Object)nodeId);
        DBObject o = this.findOne(NodeImpl.class, (DBObject)query);
        if (o == null || !o.containsField("node_id")) {
            throw new NodeNotFoundException("Unable to find node " + nodeId);
        }
        return new NodeImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public Node byNodeId(NodeId nodeId) throws NodeNotFoundException {
        return this.byNodeId(nodeId.toString());
    }

    @Override
    public Map<String, Node> allActive(Node.Type type) {
        HashMap nodes = Maps.newHashMap();
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"last_seen", (Object)new BasicDBObject("$gte", (Object)((long)Tools.getUTCTimestamp() - this.pingTimeout)));
        query.put((Object)"type", (Object)type.toString());
        for (DBObject obj : this.query(NodeImpl.class, (DBObject)query)) {
            NodeImpl node = new NodeImpl((ObjectId)obj.get("_id"), obj.toMap());
            String nodeId = (String)obj.get("node_id");
            nodes.put(nodeId, node);
        }
        return nodes;
    }

    @Override
    public Map<String, Node> allActive() {
        HashMap nodes = Maps.newHashMap();
        for (Node.Type type : Node.Type.values()) {
            nodes.putAll(this.allActive(type));
        }
        return nodes;
    }

    @Override
    public void dropOutdated() {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"last_seen", (Object)new BasicDBObject("$lt", (Object)((long)Tools.getUTCTimestamp() - this.pingTimeout)));
        this.destroyAll(NodeImpl.class, (DBObject)query);
    }

    @Override
    public void markAsAlive(Node node, boolean isLeader, String restTransportAddress) {
        node.getFields().put("last_seen", Tools.getUTCTimestamp());
        node.getFields().put("is_leader", isLeader);
        node.getFields().put("transport_address", restTransportAddress);
        try {
            this.save(node);
        }
        catch (ValidationException e) {
            throw new RuntimeException("Validation failed.", e);
        }
    }

    @Override
    public void markAsAlive(Node node, boolean isLeader, URI restTransportAddress) {
        this.markAsAlive(node, isLeader, restTransportAddress.toString());
    }

    @Override
    public boolean isOnlyLeader(NodeId nodeId) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"type", (Object)Node.Type.SERVER.toString());
        query.put((Object)"last_seen", (Object)new BasicDBObject("$gte", (Object)((long)Tools.getUTCTimestamp() - this.pingTimeout)));
        query.put((Object)"node_id", (Object)new BasicDBObject("$ne", (Object)nodeId.toString()));
        query.put((Object)"is_leader", (Object)true);
        return this.query(NodeImpl.class, (DBObject)query).size() == 0;
    }

    @Override
    public boolean isAnyLeaderPresent() {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"type", (Object)Node.Type.SERVER.toString());
        query.put((Object)"last_seen", (Object)new BasicDBObject("$gte", (Object)((long)Tools.getUTCTimestamp() - this.pingTimeout)));
        query.put((Object)"is_leader", (Object)true);
        return this.query(NodeImpl.class, (DBObject)query).size() > 0;
    }
}

