/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.lock;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.cluster.lock.Lock;
import org.graylog2.cluster.lock.LockService;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.system.NodeId;

@Singleton
public class MongoLockService
implements LockService {
    public static final String COLLECTION_NAME = "cluster_locks";
    public static final Duration MIN_LOCK_TTL = Duration.ofSeconds(60L);
    private final NodeId nodeId;
    private final MongoCollection<Document> collection;

    @Inject
    public MongoLockService(NodeId nodeId, MongoConnection mongoConnection, @Named(value="lock_service_lock_ttl") Duration leaderElectionLockTTL) {
        this.nodeId = nodeId;
        this.collection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"resource"}), new IndexOptions().unique(true));
        Bson updatedAtKey = Indexes.ascending((String[])new String[]{"updated_at"});
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(leaderElectionLockTTL.getSeconds()), TimeUnit.SECONDS);
        this.ensureTTLIndex(this.collection, updatedAtKey, indexOptions);
    }

    private void ensureTTLIndex(MongoCollection<Document> collection, Bson updatedAtKey, IndexOptions indexOptions) {
        for (Document document : collection.listIndexes()) {
            Set keySet = ((Document)document.get((Object)"key", Document.class)).keySet();
            if (!keySet.contains("updated_at")) continue;
            long expireAfterSeconds = ((Number)document.get((Object)"expireAfterSeconds", Number.class)).longValue();
            if (Objects.equals(expireAfterSeconds, indexOptions.getExpireAfter(TimeUnit.SECONDS))) {
                return;
            }
            collection.dropIndex(updatedAtKey);
        }
        collection.createIndex(updatedAtKey, indexOptions);
    }

    @Override
    public Optional<Lock> lock(@Nonnull String resource) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resource) ? 1 : 0) != 0);
        try {
            Document doc = (Document)this.collection.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)"resource", (Object)resource), Filters.eq((String)"locked_by", (Object)this.nodeId.toString())}), Updates.combine((Bson[])new Bson[]{Updates.currentDate((String)"updated_at"), Updates.setOnInsert((String)"resource", (Object)resource), Updates.setOnInsert((String)"locked_by", (Object)this.nodeId.toString())}), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
            return Optional.of(this.toLock(Objects.requireNonNull(doc)));
        }
        catch (MongoCommandException e) {
            if (e.getCode() == 11000) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @Override
    public Optional<Lock> unlock(@Nonnull String resource) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resource) ? 1 : 0) != 0);
        Document deletedDocument = (Document)this.collection.findOneAndDelete(Filters.and((Bson[])new Bson[]{Filters.eq((String)"resource", (Object)resource), Filters.eq((String)"locked_by", (Object)this.nodeId.toString())}));
        if (deletedDocument != null) {
            return Optional.of(this.toLock(deletedDocument));
        }
        return Optional.empty();
    }

    private Lock toLock(Document doc) {
        ZonedDateTime createdAt = Instant.ofEpochSecond(doc.getObjectId((Object)"_id").getTimestamp()).atZone(ZoneOffset.UTC);
        ZonedDateTime updatedAt = doc.getDate((Object)"updated_at").toInstant().atZone(ZoneOffset.UTC);
        return Lock.builder().resource(doc.getString((Object)"resource")).createdAt(createdAt).updatedAt(updatedAt).lockedBy(doc.getString((Object)"locked_by")).build();
    }
}

