/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePoller;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.events.IndexSetCreatedEvent;
import org.graylog2.indexer.indexset.events.IndexSetDeletedEvent;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.indices.events.IndicesDeletedEvent;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFieldTypePollerPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFieldTypePollerPeriodical.class);
    private final IndexFieldTypePoller poller;
    private final IndexFieldTypesService dbService;
    private final IndexSetService indexSetService;
    private final Indices indices;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final Cluster cluster;
    private final ServerStatus serverStatus;
    private final com.github.joschi.jadconfig.util.Duration fullRefreshInterval;
    private final ScheduledExecutorService scheduler;
    private volatile Set<IndexSetConfig> allIndexSetConfigs;
    private volatile Instant lastFullRefresh = Instant.MIN;
    private final ConcurrentHashMap<String, Instant> lastPoll = new ConcurrentHashMap();
    private static final Set<Lifecycle> skippedLifecycles = ImmutableSet.of((Object)((Object)Lifecycle.STARTING), (Object)((Object)Lifecycle.HALTING), (Object)((Object)Lifecycle.PAUSED), (Object)((Object)Lifecycle.FAILED), (Object)((Object)Lifecycle.UNINITIALIZED));

    @Inject
    public IndexFieldTypePollerPeriodical(IndexFieldTypePoller poller, IndexFieldTypesService dbService, IndexSetService indexSetService, Indices indices, MongoIndexSet.Factory mongoIndexSetFactory, Cluster cluster, EventBus eventBus, ServerStatus serverStatus, @Named(value="index_field_type_periodical_full_refresh_interval") com.github.joschi.jadconfig.util.Duration fullRefreshInterval, @Named(value="daemonScheduler") ScheduledExecutorService scheduler) {
        this.poller = poller;
        this.dbService = dbService;
        this.indexSetService = indexSetService;
        this.indices = indices;
        this.mongoIndexSetFactory = mongoIndexSetFactory;
        this.cluster = cluster;
        this.serverStatus = serverStatus;
        this.fullRefreshInterval = fullRefreshInterval;
        this.scheduler = scheduler;
        eventBus.register((Object)this);
    }

    @Override
    public void doRun() {
        Set<IndexSetConfig> allConfigs;
        if (this.serverIsNotRunning()) {
            return;
        }
        if (!this.cluster.isConnected()) {
            LOG.info("Cluster not connected yet, delaying index field type initialization until it is reachable.");
            while (true) {
                try {
                    this.cluster.waitForConnectedAndDeflectorHealthy();
                }
                catch (InterruptedException | TimeoutException e) {
                    LOG.warn("Interrupted or timed out waiting for Elasticsearch cluster, checking again.");
                    continue;
                }
                break;
            }
        }
        if ((allConfigs = this.allIndexSetConfigs) == null) {
            allConfigs = this.allIndexSetConfigs = new LinkedHashSet<IndexSetConfig>(this.indexSetService.findAll());
            ((ConcurrentHashMap.CollectionView)((Object)this.lastPoll.keySet())).retainAll(allConfigs.stream().map(IndexSetConfig::id).collect(Collectors.toSet()));
        }
        if (this.needsFullRefresh()) {
            try {
                this.refreshFieldTypes(allConfigs);
            }
            finally {
                this.lastFullRefresh = Instant.now();
            }
        } else {
            this.poll(allConfigs);
        }
    }

    private void refreshFieldTypes(Collection<IndexSetConfig> indexSetConfigs) {
        LOG.debug("Refreshing index field types for {} index sets.", (Object)indexSetConfigs.size());
        indexSetConfigs.forEach(indexSetConfig -> {
            String indexSetId = indexSetConfig.id();
            String indexSetTitle = indexSetConfig.title();
            try {
                ImmutableSet existingIndexTypes = ImmutableSet.copyOf(this.dbService.findForIndexSet(indexSetId));
                MongoIndexSet indexSet = this.mongoIndexSetFactory.create((IndexSetConfig)indexSetConfig);
                LOG.debug("Refreshing index field types for index set <{}/{}>", (Object)indexSetTitle, (Object)indexSetId);
                this.poller.poll(indexSet, (Set<IndexFieldTypesDTO>)existingIndexTypes).forEach(this.dbService::upsert);
                this.dbService.findForIndexSet(indexSetId).stream().filter(types -> !this.indices.exists(types.indexName())).forEach(types -> this.dbService.delete(types.id()));
            }
            finally {
                this.lastPoll.put(indexSetId, Instant.now());
            }
        });
    }

    private void poll(Collection<IndexSetConfig> indexSetConfigs) {
        indexSetConfigs.stream().filter(config -> !config.fieldTypeRefreshInterval().equals((Object)Duration.ZERO)).filter(IndexSetConfig::isWritable).filter(config -> {
            Instant previousPoll = this.lastPoll.getOrDefault(config.id(), Instant.MIN);
            Instant nextPoll = previousPoll.plusSeconds(config.fieldTypeRefreshInterval().getStandardSeconds());
            return !Instant.now().isBefore(nextPoll);
        }).forEach(this::poll);
    }

    private void poll(IndexSetConfig indexSetConfig) {
        String indexSetTitle = indexSetConfig.title();
        String indexSetId = indexSetConfig.id();
        this.scheduler.submit(() -> {
            try {
                MongoIndexSet indexSet = this.mongoIndexSetFactory.create(indexSetConfig);
                String activeWriteIndex = indexSet.getActiveWriteIndex();
                if (activeWriteIndex != null) {
                    LOG.debug("Updating index field types for active write index <{}> in index set <{}/{}>", new Object[]{activeWriteIndex, indexSetTitle, indexSetId});
                    this.poller.pollIndex(activeWriteIndex, indexSetId).ifPresent(this.dbService::upsert);
                } else {
                    LOG.warn("Active write index for index set \"{}\" ({}) doesn't exist yet", (Object)indexSetTitle, (Object)indexSetId);
                }
            }
            catch (TooManyAliasesException e) {
                LOG.error("Couldn't get active write index", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("Couldn't update field types for index set <{}/{}>", new Object[]{indexSetTitle, indexSetId, e});
            }
            finally {
                this.lastPoll.put(indexSetId, Instant.now());
            }
        });
    }

    private boolean needsFullRefresh() {
        Instant nextFullRefresh = this.lastFullRefresh.plusSeconds(this.fullRefreshInterval.toSeconds());
        return !Instant.now().isBefore(nextFullRefresh);
    }

    private boolean serverIsNotRunning() {
        Lifecycle currentLifecycle = this.serverStatus.getLifecycle();
        return skippedLifecycles.contains((Object)currentLifecycle);
    }

    @Subscribe
    public void handleIndexSetCreation(IndexSetCreatedEvent event) {
        String indexSetId = event.indexSet().id();
        LOG.debug("Resetting field type polling after creation of index set <{}>", (Object)indexSetId);
        this.allIndexSetConfigs = null;
    }

    @Subscribe
    public void handleIndexSetDeletion(IndexSetDeletedEvent event) {
        String indexSetId = event.id();
        LOG.debug("Resetting field type polling after deletion of index set <{}>", (Object)indexSetId);
        this.allIndexSetConfigs = null;
    }

    @Subscribe
    public void handleIndexDeletion(IndicesDeletedEvent event) {
        event.indices().forEach(indexName -> {
            LOG.debug("Removing field type information for deleted index <{}>", indexName);
            this.dbService.delete((String)indexName);
        });
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

