/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.V20180214093600_AdjustDashboardPositionToNewResolution.MigrationDashboard;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.validators.ValidationResult;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationDashboardService {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationDashboardService.class);
    private static final String COLLECTION = "dashboards";
    private final MongoConnection mongoConnection;

    @Inject
    MigrationDashboardService(MongoConnection mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    String save(MigrationDashboard model) throws ValidationException {
        Map<String, List<ValidationResult>> errors = this.validate(model.getValidations(), model.getFields());
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
        BasicDBObject doc = new BasicDBObject(model.getFields());
        doc.put((Object)"_id", (Object)new ObjectId(model.getId()));
        this.fieldTransformations((Map<String, Object>)doc);
        BasicDBObject q = new BasicDBObject("_id", (Object)new ObjectId(model.getId()));
        this.collection().update((DBObject)q, (DBObject)doc, true, false);
        return model.getId();
    }

    private Map<String, List<ValidationResult>> validate(Map<String, Validator> validators, Map<String, Object> fields) {
        if (validators == null || validators.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ValidationResult>> validationErrors = new HashMap<String, List<ValidationResult>>();
        for (Map.Entry<String, Validator> validation : validators.entrySet()) {
            Validator v = validation.getValue();
            String field = validation.getKey();
            try {
                ValidationResult validationResult = v.validate(fields.get(field));
                if (!(validationResult instanceof ValidationResult.ValidationFailed)) continue;
                LOG.debug("Validation failure: [{}] on field [{}]", (Object)v.getClass().getCanonicalName(), (Object)field);
                validationErrors.computeIfAbsent(field, k -> new ArrayList());
                ((List)validationErrors.get(field)).add(validationResult);
            }
            catch (Exception e) {
                String error = "Error while trying to validate <" + field + ">, got exception: " + e;
                LOG.debug(error);
                validationErrors.computeIfAbsent(field, k -> new ArrayList());
                ((List)validationErrors.get(field)).add(new ValidationResult.ValidationFailed(error));
            }
        }
        return validationErrors;
    }

    private void fieldTransformations(Map<String, Object> doc) {
        for (Map.Entry<String, Object> x : doc.entrySet()) {
            if (x.getValue() instanceof Map) {
                x.setValue(Maps.newHashMap((Map)((Map)x.getValue())));
                this.fieldTransformations((Map)x.getValue());
                continue;
            }
            if (x.getValue() instanceof DateTime) {
                doc.put(x.getKey(), ((DateTime)x.getValue()).toDate());
            }
            if (!(x.getValue() instanceof NodeId)) continue;
            doc.put(x.getKey(), x.getValue().toString());
        }
    }

    List<MigrationDashboard> all() {
        List<DBObject> results = this.cursorToList(this.collection().find());
        Stream<MigrationDashboard> dashboardStream = results.stream().map(o -> new MigrationDashboard((ObjectId)o.get("_id"), o.toMap()));
        return dashboardStream.collect(Collectors.toList());
    }

    protected List<DBObject> cursorToList(DBCursor cursor) {
        if (cursor == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList arrayList = Lists.newArrayList((Iterable)cursor);
            return arrayList;
        }
        finally {
            cursor.close();
        }
    }

    long count() {
        return this.collection().count();
    }

    private DBCollection collection() {
        return this.mongoConnection.getDatabase().getCollection(COLLECTION);
    }
}

