/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.blocks.IndicesBlockStatus;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.periodical.IndexRotationThread;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexBlockCheck
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRotationThread.class);
    private final NotificationService notificationService;
    private final IndexSetRegistry indexSetRegistry;
    private final Cluster cluster;
    private final Indices indices;
    private final NodeId nodeId;

    @Inject
    public IndexBlockCheck(NotificationService notificationService, IndexSetRegistry indexSetRegistry, Cluster cluster, Indices indices, NodeId nodeId) {
        this.notificationService = notificationService;
        this.indexSetRegistry = indexSetRegistry;
        this.cluster = cluster;
        this.indices = indices;
        this.nodeId = nodeId;
    }

    @Override
    public void doRun() {
        if (this.cluster.isConnected()) {
            IndicesBlockStatus indicesBlockStatus = this.indices.getIndicesBlocksStatus(this.getAllActiveWriteIndices());
            if (indicesBlockStatus.countBlockedIndices() > 0) {
                this.indicesBlockedProblemNotification("Indices blocked", indicesBlockStatus.countBlockedIndices() + " indices are blocked.", indicesBlockStatus);
            } else {
                this.notificationService.fixed(Notification.Type.ES_INDEX_BLOCKED);
            }
        } else {
            LOG.debug("Elasticsearch cluster isn't healthy. Skipping index block check.");
        }
    }

    private List<String> getAllActiveWriteIndices() {
        ArrayList<String> activeWriteIndices = new ArrayList<String>();
        this.indexSetRegistry.forEach(indexSet -> {
            try {
                String activeWriteIndex = indexSet.getActiveWriteIndex();
                if (activeWriteIndex != null) {
                    activeWriteIndices.add(activeWriteIndex);
                }
            }
            catch (Exception e) {
                LOG.error("Couldn't perform index block check for index set : " + indexSet, (Throwable)e);
            }
        });
        return activeWriteIndices;
    }

    private void indicesBlockedProblemNotification(String title, String description, IndicesBlockStatus indicesBlockStatus) {
        Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.ES_INDEX_BLOCKED).addSeverity(Notification.Severity.URGENT).addDetail("title", title).addDetail("description", description).addDetail("blockDetails", indicesBlockStatus.toBlockDetails());
        this.notificationService.publishIfFirst(notification);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 30;
    }
}

