/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import javax.activation.MimetypesFileTypeMap;
import okhttp3.OkHttpClient;
import org.graylog.failure.DefaultFailureHandler;
import org.graylog.failure.DefaultFailureHandlingConfiguration;
import org.graylog.failure.FailureHandler;
import org.graylog.failure.FailureHandlingConfiguration;
import org.graylog.failure.FailureHandlingService;
import org.graylog2.indexer.EventIndexTemplateProvider;
import org.graylog2.indexer.IndexTemplateProvider;
import org.graylog2.indexer.MessageIndexTemplateProvider;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.providers.EventBusProvider;
import org.graylog2.shared.bindings.providers.NodeIdProvider;
import org.graylog2.shared.bindings.providers.OkHttpClientProvider;
import org.graylog2.shared.bindings.providers.ProxiedRequestsExecutorService;
import org.graylog2.shared.bindings.providers.ServiceManagerProvider;
import org.graylog2.shared.buffers.InputBufferImpl;
import org.graylog2.shared.buffers.NoopInputBuffer;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.buffers.processors.DecodingProcessor;
import org.graylog2.shared.inputs.InputRegistry;

public class GenericBindings
extends Graylog2Module {
    private final boolean isMigrationCommand;

    public GenericBindings(boolean isMigrationCommand) {
        this.isMigrationCommand = isMigrationCommand;
    }

    protected void configure() {
        this.bind(LocalMetricRegistry.class).in(Scopes.NO_SCOPE);
        this.install(new FactoryModuleBuilder().build(DecodingProcessor.Factory.class));
        this.bind(ProcessBuffer.class).asEagerSingleton();
        if (this.isMigrationCommand) {
            this.bind(InputBuffer.class).to(NoopInputBuffer.class);
        } else {
            this.bind(InputBuffer.class).to(InputBufferImpl.class);
        }
        this.bind(NodeId.class).toProvider(NodeIdProvider.class);
        if (!this.isMigrationCommand) {
            this.bind(ServiceManager.class).toProvider(ServiceManagerProvider.class).asEagerSingleton();
        }
        this.bind(ThroughputCounter.class);
        this.bind(EventBus.class).toProvider(EventBusProvider.class).in(Scopes.SINGLETON);
        this.bind(Semaphore.class).annotatedWith((Annotation)Names.named((String)"JournalSignal")).toInstance((Object)new Semaphore(0));
        this.install(new FactoryModuleBuilder().build((TypeLiteral)new TypeLiteral<IOState.Factory<MessageInput>>(){}));
        this.bind(InputRegistry.class).asEagerSingleton();
        this.bind(OkHttpClient.class).toProvider(OkHttpClientProvider.class).asEagerSingleton();
        this.bind(MimetypesFileTypeMap.class).toInstance((Object)new MimetypesFileTypeMap());
        this.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)"proxiedRequestsExecutorService")).toProvider(ProxiedRequestsExecutorService.class).asEagerSingleton();
        this.bind(FailureHandler.class).annotatedWith((Annotation)Names.named((String)"fallbackFailureHandler")).to(DefaultFailureHandler.class).asEagerSingleton();
        Multibinder.newSetBinder((Binder)this.binder(), FailureHandler.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), FailureHandlingConfiguration.class).setDefault().to(DefaultFailureHandlingConfiguration.class);
        MapBinder indexTemplateProviderBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, IndexTemplateProvider.class);
        indexTemplateProviderBinder.addBinding((Object)"messages").to(MessageIndexTemplateProvider.class);
        indexTemplateProviderBinder.addBinding((Object)"events").to(EventIndexTemplateProvider.class);
        this.serviceBinder().addBinding().to(FailureHandlingService.class).in(Scopes.SINGLETON);
    }
}

