/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import javax.ws.rs.container.DynamicFeature;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.rest.resources.RestResourcesModule;
import org.graylog2.shared.rest.resources.RestResourcesSharedModule;
import org.graylog2.shared.security.ShiroSecurityBinding;
import org.graylog2.web.DevelopmentIndexHtmlGenerator;
import org.graylog2.web.IndexHtmlGenerator;
import org.graylog2.web.ProductionIndexHtmlGenerator;
import org.graylog2.web.resources.WebResourcesModule;

public class RestApiBindings
extends Graylog2Module {
    protected void configure() {
        this.bindDynamicFeatures();
        this.bindContainerResponseFilters();
        this.jerseyExceptionMapperBinder();
        this.jerseyAdditionalComponentsBinder();
        String development = System.getenv("DEVELOPMENT");
        if (development == null || development.equalsIgnoreCase("false")) {
            this.bind(IndexHtmlGenerator.class).to(ProductionIndexHtmlGenerator.class).asEagerSingleton();
        } else {
            this.bind(IndexHtmlGenerator.class).to(DevelopmentIndexHtmlGenerator.class).asEagerSingleton();
        }
        this.install((Module)new WebResourcesModule());
        this.install((Module)new RestResourcesModule());
        this.install((Module)new RestResourcesSharedModule());
    }

    private void bindDynamicFeatures() {
        Multibinder<Class<? extends DynamicFeature>> setBinder = this.jerseyDynamicFeatureBinder();
        setBinder.addBinding().toInstance(ShiroSecurityBinding.class);
    }

    private void bindContainerResponseFilters() {
        this.jerseyContainerResponseFilterBinder();
    }
}

