/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import org.graylog.plugins.map.config.AutoValue_GeoIpResolverConfig;
import org.graylog.plugins.map.config.DatabaseVendorType;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class GeoIpResolverConfig {
    @JsonProperty(value="enabled")
    public abstract boolean enabled();

    @JsonProperty(value="enforce_graylog_schema")
    public abstract boolean enforceGraylogSchema();

    @JsonProperty(value="db_vendor_type")
    public abstract DatabaseVendorType databaseVendorType();

    @JsonProperty(value="city_db_path")
    public abstract String cityDbPath();

    @JsonProperty(value="asn_db_path")
    public abstract String asnDbPath();

    @JsonCreator
    public static GeoIpResolverConfig create(@JsonProperty(value="enabled") boolean cityEnabled, @JsonProperty(value="enforce_graylog_schema") boolean enforceGraylogSchema, @JsonProperty(value="db_vendor_type") DatabaseVendorType databaseVendorType, @JsonProperty(value="city_db_path") String cityDbPath, @JsonProperty(value="asn_db_path") String asnDbPath) {
        return GeoIpResolverConfig.builder().enabled(cityEnabled).enforceGraylogSchema(enforceGraylogSchema).databaseVendorType(databaseVendorType == null ? DatabaseVendorType.MAXMIND : databaseVendorType).cityDbPath(cityDbPath).asnDbPath(asnDbPath).build();
    }

    public static GeoIpResolverConfig defaultConfig() {
        return GeoIpResolverConfig.builder().enabled(false).databaseVendorType(DatabaseVendorType.MAXMIND).enforceGraylogSchema(false).cityDbPath("/etc/graylog/server/GeoLite2-City.mmdb").asnDbPath("/etc/graylog/server/GeoLite2-ASN.mmdb").build();
    }

    public static Builder builder() {
        return new AutoValue_GeoIpResolverConfig.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder enabled(boolean var1);

        public abstract Builder enforceGraylogSchema(boolean var1);

        public abstract Builder databaseVendorType(DatabaseVendorType var1);

        public abstract Builder cityDbPath(String var1);

        public abstract Builder asnDbPath(String var1);

        public abstract GeoIpResolverConfig build();
    }
}

