/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Optional;
import org.graylog.plugins.views.search.engine.SearchConfig;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.Period;

public class SearchConfigProvider
implements Provider<SearchConfig> {
    private final ClusterConfigService clusterConfigService;

    @Inject
    public SearchConfigProvider(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
    }

    public SearchConfig get() {
        SearchesClusterConfig searchesClusterConfig = this.clusterConfigService.get(SearchesClusterConfig.class);
        Period queryTimeRangeLimit = Optional.ofNullable(searchesClusterConfig).map(SearchesClusterConfig::queryTimeRangeLimit).orElse(Period.ZERO);
        return new SearchConfig(queryTimeRangeLimit);
    }
}

