/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.graylog.plugins.views.search.validation.ParsedQuery;
import org.graylog.plugins.views.search.validation.TermCollectingQueryParser;
import org.graylog.plugins.views.search.validation.TermCollectingQueryVisitor;

public class LuceneQueryParser {
    private final TermCollectingQueryParser parser = new TermCollectingQueryParser("_default_", (Analyzer)new StandardAnalyzer());

    @Inject
    public LuceneQueryParser(@Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.parser.setSplitOnWhitespace(true);
        this.parser.setAllowLeadingWildcard(allowLeadingWildcard);
    }

    public ParsedQuery parse(String query) throws ParseException {
        Query parsed = this.parser.parse(query);
        ParsedQuery.Builder builder = ParsedQuery.builder().query(query);
        builder.tokensBuilder().addAll(this.parser.getTokens());
        TermCollectingQueryVisitor visitor = new TermCollectingQueryVisitor(this.parser.getTokens());
        parsed.visit((QueryVisitor)visitor);
        builder.termsBuilder().addAll(visitor.getParsedTerms());
        return builder.build();
    }
}

