/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.elasticsearch.QueryParam;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.errors.EmptyParameterError;
import org.graylog.plugins.views.search.errors.MissingEnterpriseLicenseException;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog.plugins.views.search.errors.UnboundParameterError;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.validation.LuceneQueryParser;
import org.graylog.plugins.views.search.validation.ParsedQuery;
import org.graylog.plugins.views.search.validation.ParsedTerm;
import org.graylog.plugins.views.search.validation.QueryValidationService;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationResponse;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;

@Singleton
public class QueryValidationServiceImpl
implements QueryValidationService {
    private final LuceneQueryParser luceneQueryParser;
    private final MappedFieldTypesService mappedFieldTypesService;
    private final QueryStringDecorators queryStringDecorators;

    @Inject
    public QueryValidationServiceImpl(LuceneQueryParser luceneQueryParser, MappedFieldTypesService mappedFieldTypesService, QueryStringDecorators queryStringDecorators) {
        this.luceneQueryParser = luceneQueryParser;
        this.mappedFieldTypesService = mappedFieldTypesService;
        this.queryStringDecorators = queryStringDecorators;
    }

    @Override
    public ValidationResponse validate(ValidationRequest req) {
        String rawQuery = req.query().queryString();
        if (StringUtils.isEmpty((CharSequence)rawQuery)) {
            return ValidationResponse.ok();
        }
        try {
            this.decoratedQuery(req);
        }
        catch (SearchException searchException) {
            return this.convert(searchException);
        }
        catch (MissingEnterpriseLicenseException licenseException) {
            return ValidationResponse.error(this.paramsToValidationErrors((Set<QueryParam>)licenseException.getQueryParams(), ValidationType.MISSING_LICENSE, param -> "Search parameter used without enterprise license: " + param.name()));
        }
        try {
            ParsedQuery parsedQuery = this.luceneQueryParser.parse(rawQuery);
            List<ParsedTerm> unknownFields = this.getUnknownFields(req, parsedQuery);
            List<ParsedTerm> invalidOperators = parsedQuery.invalidOperators();
            List<ValidationMessage> explanations = this.getExplanations(unknownFields, invalidOperators);
            return explanations.isEmpty() ? ValidationResponse.ok() : ValidationResponse.warning(explanations);
        }
        catch (ParseException e) {
            return ValidationResponse.error(this.toExplanation(e));
        }
    }

    private ValidationResponse convert(SearchException searchException) {
        if (searchException.error() instanceof UnboundParameterError) {
            UnboundParameterError error = (UnboundParameterError)searchException.error();
            return ValidationResponse.error(this.paramsToValidationErrors(error.allUnknownParameters(), ValidationType.UNDECLARED_PARAMETER, param -> "Unbound required parameter used: " + param.name()));
        }
        if (searchException.error() instanceof EmptyParameterError) {
            EmptyParameterError error = (EmptyParameterError)searchException.error();
            return ValidationResponse.warning(this.paramsToValidationErrors(Collections.singleton(error.getParameterUsage()), ValidationType.EMPTY_PARAMETER, param -> error.description()));
        }
        return ValidationResponse.error(Collections.singletonList(ValidationMessage.fromException(searchException)));
    }

    private List<ValidationMessage> paramsToValidationErrors(Set<QueryParam> params, ValidationType errorType, Function<QueryParam, String> messageBuilder) {
        return params.stream().flatMap(param -> {
            String errorMessage = (String)messageBuilder.apply((QueryParam)param);
            return param.positions().stream().map(p -> ValidationMessage.builder(errorType).errorMessage(errorMessage).beginLine(p.line()).endLine(p.line()).beginColumn(p.beginColumn()).endColumn(p.endColumn()).relatedProperty(param.name()).build());
        }).collect(Collectors.toList());
    }

    private List<ValidationMessage> toExplanation(ParseException parseException) {
        return Collections.singletonList(ValidationMessage.fromException((Exception)((Object)parseException)));
    }

    private List<ValidationMessage> getExplanations(List<ParsedTerm> unknownFields, List<ParsedTerm> invalidOperators) {
        Stream<ValidationMessage> unknownFieldsStream = unknownFields.stream().map(f -> {
            ValidationMessage.Builder message = ValidationMessage.builder(ValidationType.UNKNOWN_FIELD).relatedProperty(f.getRealFieldName()).errorMessage("Query contains unknown field: " + f.getRealFieldName());
            f.keyToken().ifPresent(t -> {
                message.beginLine(t.beginLine());
                message.beginColumn(t.beginColumn());
                message.endLine(t.endLine());
                message.endColumn(t.endColumn());
            });
            return message.build();
        });
        Stream<ValidationMessage> invalidOperatorsStream = invalidOperators.stream().map(term -> {
            String errorMessage = String.format(Locale.ROOT, "Query contains invalid operator \"%s\". All AND / OR / NOT operators have to be written uppercase", term.value());
            ValidationMessage.Builder message = ValidationMessage.builder(ValidationType.INVALID_OPERATOR).errorMessage(errorMessage);
            term.keyToken().ifPresent(t -> {
                message.beginLine(t.beginLine());
                message.beginColumn(t.beginColumn());
                message.endLine(t.endLine());
                message.endColumn(t.endColumn());
            });
            return message.build();
        });
        return Streams.concat((Stream[])new Stream[]{unknownFieldsStream, invalidOperatorsStream}).distinct().collect(Collectors.toList());
    }

    private List<ParsedTerm> getUnknownFields(ValidationRequest req, ParsedQuery query) {
        Set availableFields = this.mappedFieldTypesService.fieldTypesByStreamIds(req.streams(), req.timerange()).stream().map(MappedFieldTypeDTO::name).collect(Collectors.toSet());
        return query.terms().stream().filter(t -> !t.isDefaultField()).filter(term -> !availableFields.contains(term.getRealFieldName())).collect(Collectors.toList());
    }

    private String decoratedQuery(ValidationRequest req) {
        ParameterProvider parameterProvider = name -> req.parameters().stream().filter(p -> Objects.equals(p.name(), name)).findFirst();
        Query query = Query.builder().query(req.query()).timerange(req.timerange()).build();
        return this.queryStringDecorators.decorate(req.getCombinedQueryWithFilter(), parameterProvider, query);
    }
}

