/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.graylog.plugins.views.search.validation.ImmutableToken;
import org.graylog.plugins.views.search.validation.ParsedTerm;

public class TermCollectingQueryVisitor
extends QueryVisitor {
    private final List<ImmutableToken> availableTokens;
    private final List<ImmutableToken> processedTokens = new ArrayList<ImmutableToken>();
    private final List<ParsedTerm> parsedTerms = new ArrayList<ParsedTerm>();

    public TermCollectingQueryVisitor(List<ImmutableToken> availableTokens) {
        this.availableTokens = new ArrayList<ImmutableToken>(availableTokens);
    }

    public void consumeTerms(Query query, Term ... terms) {
        super.consumeTerms(query, terms);
        this.processTerms(terms);
    }

    private void processTerms(Term ... terms) {
        for (Term t : terms) {
            ParsedTerm.Builder termBuilder = ParsedTerm.builder().field(t.field()).value(t.text());
            if (t.field().equals("_default_") || t.field().equals("_exists_")) {
                this.streamOf(this.availableTokens, this.processedTokens).filter(token -> token.matches(20, t.text())).findFirst().ifPresent(token -> {
                    termBuilder.keyToken((ImmutableToken)token);
                    this.processedTokens.add((ImmutableToken)token);
                    this.availableTokens.remove(token);
                });
            } else {
                this.streamOf(this.availableTokens, this.processedTokens).filter(token -> token.kind() == 20).filter(token -> token.image().equals(t.field())).findFirst().ifPresent(token -> {
                    termBuilder.keyToken((ImmutableToken)token);
                    this.processedTokens.add((ImmutableToken)token);
                    this.availableTokens.remove(token);
                });
            }
            this.parsedTerms.add(termBuilder.build());
        }
    }

    public void visitLeaf(Query query) {
        if (query instanceof RegexpQuery) {
            this.processTerms(((RegexpQuery)query).getRegexp());
        } else if (query instanceof TermRangeQuery) {
            TermRangeQuery trq = (TermRangeQuery)query;
            this.processTerms(new Term(trq.getField(), trq.getLowerTerm().utf8ToString()), new Term(trq.getField(), trq.getUpperTerm().utf8ToString()));
        } else if (query instanceof WildcardQuery) {
            this.processTerms(((WildcardQuery)query).getTerm());
        } else if (query instanceof PrefixQuery) {
            this.processTerms(((PrefixQuery)query).getPrefix());
        } else if (query instanceof FuzzyQuery) {
            this.processTerms(((FuzzyQuery)query).getTerm());
        } else {
            throw new IllegalArgumentException("Unrecognized query type: " + query.getClass().getName());
        }
    }

    public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
        return this;
    }

    private Stream<ImmutableToken> streamOf(List<ImmutableToken> availableTokens, List<ImmutableToken> processedTokens) {
        return Streams.concat((Stream[])new Stream[]{availableTokens.stream(), processedTokens.stream()});
    }

    public List<ParsedTerm> getParsedTerms() {
        return this.parsedTerms;
    }
}

