/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IgnoreIndexTemplate;
import org.graylog2.indexer.IndexMappingFactory;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexTemplateNotFoundException;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indices.HealthStatus;
import org.graylog2.indexer.indices.IndexSettings;
import org.graylog2.indexer.indices.IndicesAdapter;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.indices.events.IndicesClosedEvent;
import org.graylog2.indexer.indices.events.IndicesDeletedEvent;
import org.graylog2.indexer.indices.events.IndicesReopenedEvent;
import org.graylog2.indexer.indices.stats.IndexStatistics;
import org.graylog2.indexer.searches.IndexRangeStats;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Indices {
    private static final Logger LOG = LoggerFactory.getLogger(Indices.class);
    public static final String REOPENED_ALIAS_SUFFIX = "_reopened";
    private final IndexMappingFactory indexMappingFactory;
    private final NodeId nodeId;
    private final AuditEventSender auditEventSender;
    private final EventBus eventBus;
    private final IndicesAdapter indicesAdapter;

    @Inject
    public Indices(IndexMappingFactory indexMappingFactory, NodeId nodeId, AuditEventSender auditEventSender, EventBus eventBus, IndicesAdapter indicesAdapter) {
        this.indexMappingFactory = indexMappingFactory;
        this.nodeId = nodeId;
        this.auditEventSender = auditEventSender;
        this.eventBus = eventBus;
        this.indicesAdapter = indicesAdapter;
    }

    public void move(String source, String target) {
        this.indicesAdapter.move(source, target, result -> {
            LOG.info("Moving index <{}> to <{}>: Bulk indexed {} messages, took {} ms, failures: {}", new Object[]{source, target, result, result.tookMs(), result.hasFailedItems()});
            if (result.hasFailedItems()) {
                throw new ElasticsearchException("Failed to move a message. Check your indexer log.");
            }
        });
    }

    public void delete(String indexName) {
        this.indicesAdapter.delete(indexName);
        this.eventBus.post((Object)IndicesDeletedEvent.create(indexName));
    }

    public void close(String indexName) {
        if (this.isReopened(indexName)) {
            this.indicesAdapter.removeAlias(indexName, indexName + REOPENED_ALIAS_SUFFIX);
        }
        this.indicesAdapter.close(indexName);
        this.eventBus.post((Object)IndicesClosedEvent.create(indexName));
    }

    public long numberOfMessages(String indexName) throws IndexNotFoundException {
        return this.indicesAdapter.numberOfMessages(indexName);
    }

    public JsonNode getIndexStats(IndexSet indexSet) {
        return this.indicesAdapter.getIndexStats(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public boolean exists(String indexName) {
        try {
            return this.indicesAdapter.exists(indexName);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't check existence of index " + indexName, (Throwable)e);
        }
    }

    public boolean aliasExists(String alias) {
        try {
            return this.indicesAdapter.aliasExists(alias);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't check existence of alias " + alias, (Throwable)e);
        }
    }

    @NotNull
    public Map<String, Set<String>> getIndexNamesAndAliases(String indexPattern) {
        return this.indicesAdapter.aliases(indexPattern);
    }

    public Optional<String> aliasTarget(String alias) throws TooManyAliasesException {
        Set<String> indices = this.indicesAdapter.resolveAlias(alias);
        if (indices.size() > 1) {
            throw new TooManyAliasesException(indices);
        }
        return indices.stream().findFirst();
    }

    public Set<String> aliasTargets(String alias) {
        return this.indicesAdapter.resolveAlias(alias);
    }

    public void ensureIndexTemplate(IndexSet indexSet) {
        block4: {
            IndexSetConfig indexSetConfig = indexSet.getConfig();
            String templateName = indexSetConfig.indexTemplateName();
            try {
                Map<String, Object> template = this.buildTemplate(indexSet, indexSetConfig);
                if (this.indicesAdapter.ensureIndexTemplate(templateName, template)) {
                    LOG.info("Successfully ensured index template {}", (Object)templateName);
                } else {
                    LOG.warn("Failed to create index template {}", (Object)templateName);
                }
            }
            catch (IgnoreIndexTemplate e) {
                LOG.warn(e.getMessage());
                if (!e.isFailOnMissingTemplate() || this.indicesAdapter.indexTemplateExists(templateName)) break block4;
                throw new IndexTemplateNotFoundException(StringUtils.f("No index template with name '%s' (type - '%s') found in Elasticsearch", templateName, indexSetConfig.indexTemplateType().orElse(null)));
            }
        }
    }

    public Map<String, Object> getIndexTemplate(IndexSet indexSet) {
        return this.indexMappingFactory.createIndexMapping(indexSet.getConfig()).toTemplate(indexSet.getConfig(), indexSet.getIndexWildcard());
    }

    public void deleteIndexTemplate(IndexSet indexSet) {
        String templateName = indexSet.getConfig().indexTemplateName();
        boolean result = this.indicesAdapter.deleteIndexTemplate(templateName);
        if (result) {
            LOG.info("Successfully deleted index template {}", (Object)templateName);
        }
    }

    public boolean create(String indexName, IndexSet indexSet) {
        IndexSettings indexSettings = IndexSettings.create(indexSet.getConfig().shards(), indexSet.getConfig().replicas());
        try {
            this.ensureIndexTemplate(indexSet);
            this.indicesAdapter.create(indexName, indexSettings);
        }
        catch (Exception e) {
            LOG.warn("Couldn't create index {}. Error: {}", new Object[]{indexName, e.getMessage(), e});
            this.auditEventSender.failure(AuditActor.system(this.nodeId), "server:es_index:create", (Map<String, Object>)ImmutableMap.of((Object)"indexName", (Object)indexName));
            return false;
        }
        this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index:create", (Map<String, Object>)ImmutableMap.of((Object)"indexName", (Object)indexName));
        return true;
    }

    private Map<String, Object> buildTemplate(IndexSet indexSet, IndexSetConfig indexSetConfig) throws IgnoreIndexTemplate {
        return this.indexMappingFactory.createIndexMapping(indexSetConfig).toTemplate(indexSetConfig, indexSet.getIndexWildcard(), -1);
    }

    public Map<String, Set<String>> getAllMessageFieldsForIndices(String[] writeIndexWildcards) {
        return this.indicesAdapter.fieldsInIndices(writeIndexWildcards);
    }

    public Set<String> getAllMessageFields(String[] writeIndexWildcards) {
        Map<String, Set<String>> fieldsForIndices = this.getAllMessageFieldsForIndices(writeIndexWildcards);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Set<String> fields : fieldsForIndices.values()) {
            result.addAll(fields);
        }
        return result.build();
    }

    public void setReadOnly(String index) {
        this.indicesAdapter.setReadOnly(index);
    }

    public void flush(String index) {
        this.indicesAdapter.flush(index);
    }

    public void reopenIndex(String index) {
        this.markIndexReopened(index);
        this.openIndex(index);
    }

    public void markIndexReopened(String index) {
        this.indicesAdapter.markIndexReopened(index);
    }

    private void openIndex(String index) {
        this.indicesAdapter.openIndex(index);
        this.eventBus.post((Object)IndicesReopenedEvent.create(index));
    }

    public boolean isReopened(String indexName) {
        Set<String> aliasTarget = this.aliasTargets(indexName + REOPENED_ALIAS_SUFFIX);
        return !aliasTarget.isEmpty();
    }

    public Map<String, Boolean> areReopened(Collection<String> indices) {
        return indices.stream().collect(Collectors.toMap(Function.identity(), this::isReopened));
    }

    public Set<String> getClosedIndices(Collection<String> indices) {
        return this.indicesAdapter.closedIndices(indices);
    }

    public Set<String> getClosedIndices(IndexSet indexSet) {
        return this.getClosedIndices(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public Set<String> getIndices(IndexSet indexSet, String ... statusFilter) {
        String indexWildcard = indexSet.getIndexWildcard();
        List<String> status = Arrays.asList(statusFilter);
        return this.indicesAdapter.indices(indexWildcard, status, indexSet.getConfig().id());
    }

    public boolean isOpen(String indexName) {
        return this.indicesAdapter.isOpen(indexName);
    }

    public boolean isClosed(String indexName) {
        return this.indicesAdapter.isClosed(indexName);
    }

    public Set<String> getReopenedIndices(Collection<String> indices) {
        return indices.stream().filter(this::isReopened).collect(Collectors.toSet());
    }

    public Set<String> getReopenedIndices(IndexSet indexSet) {
        return this.getReopenedIndices(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public Optional<IndexStatistics> getIndexStats(String index) {
        return this.indicesAdapter.getIndexStats(index);
    }

    public Optional<Long> getStoreSizeInBytes(String index) {
        return this.indicesAdapter.storeSizeInBytes(index);
    }

    public Set<IndexStatistics> getIndicesStats(IndexSet indexSet) {
        return this.getIndicesStats(Collections.singleton(indexSet.getIndexWildcard()));
    }

    public Set<IndexStatistics> getIndicesStats(Collection<String> indices) {
        return this.indicesAdapter.indicesStats(indices);
    }

    public void cycleAlias(String aliasName, String targetIndex) {
        this.indicesAdapter.cycleAlias(aliasName, targetIndex);
    }

    public void cycleAlias(String aliasName, String targetIndex, String oldIndex) {
        this.indicesAdapter.cycleAlias(aliasName, targetIndex, oldIndex);
    }

    public void removeAliases(String alias, Set<String> indices) {
        this.indicesAdapter.removeAliases(indices, alias);
    }

    public void optimizeIndex(String index, int maxNumSegments, Duration timeout) {
        this.indicesAdapter.optimizeIndex(index, maxNumSegments, timeout);
    }

    HealthStatus waitForRecovery(String index, int timeout) {
        LOG.debug("Waiting until index health status of index {} is healthy", (Object)index);
        return this.indicesAdapter.waitForRecovery(index, timeout);
    }

    public HealthStatus waitForRecovery(String index) {
        LOG.debug("Waiting until index health status of index {} is healthy", (Object)index);
        return this.indicesAdapter.waitForRecovery(index);
    }

    public static <E extends Exception> void checkIfHealthy(HealthStatus healthStatus, Function<HealthStatus, E> errorMessageSupplier) throws E {
        if (healthStatus.equals((Object)HealthStatus.Red)) {
            throw (Exception)errorMessageSupplier.apply(healthStatus);
        }
    }

    public Optional<DateTime> indexCreationDate(String index) {
        return this.indicesAdapter.indexCreationDate(index);
    }

    public IndexRangeStats indexRangeStatsOfIndex(String index) {
        return this.indicesAdapter.indexRangeStatsOfIndex(index);
    }

    public String getIndexId(String indexName) {
        return this.indicesAdapter.getIndexId(indexName);
    }
}

