/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.github.zafarkhaja.semver.expr.LexerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.configuration.validators.SearchVersionRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.resources.system.SatisfiesVersionResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.providers.ElasticsearchVersionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/SearchVersion", description="Checks system search version requirements")
@Path(value="/system/searchVersion")
@Produces(value={"application/json"})
@RequiresAuthentication
public class SearchVersionResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchVersionResource.class);
    private final ElasticsearchVersionProvider versionProvider;

    @Inject
    public SearchVersionResource(ElasticsearchVersionProvider versionProvider) {
        this.versionProvider = versionProvider;
    }

    @GET
    @Path(value="/satisfiesVersion/{distribution}")
    @ApiOperation(value="Confirms whether the current search version satisfies a given distribution and an optional Semantic Versioning version")
    public SatisfiesVersionResponse satisfiesVersion(@ApiParam(name="distribution", required=true) @PathParam(value="distribution") String distribution, @ApiParam(name="version") @QueryParam(value="version") String version) {
        boolean satisfied;
        SearchVersion.Distribution requiredDistribution;
        if (version == null || version.isEmpty()) {
            version = ">0";
        }
        try {
            requiredDistribution = SearchVersion.Distribution.valueOf(distribution.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unsupported distribution {}. Valid values are [opensearch, elasticsearch].", (Object)distribution);
            throw new InternalServerErrorException(StringUtils.f("Unsupported distribution %s. Valid values are [opensearch, elasticsearch].", distribution));
        }
        SearchVersion currentVersion = this.versionProvider.get();
        SearchVersionRange requiredVersion = SearchVersionRange.of(requiredDistribution, version);
        try {
            LOG.debug("Checking current version {} satisfies required version {} {}", new Object[]{currentVersion, requiredDistribution, version});
            satisfied = currentVersion.satisfies(requiredVersion);
        }
        catch (LexerException e) {
            LOG.error("Unable to create a search version range for SemVer expression {}", (Object)version);
            throw new InternalServerErrorException(StringUtils.f("Unable to create a search version range for SemVer expression %s", version));
        }
        String errorMessage = "";
        if (!satisfied) {
            errorMessage = StringUtils.f("Current search version %s does not satisfy required version %s %s", new Object[]{currentVersion, requiredDistribution, version});
        }
        return SatisfiesVersionResponse.Builder.create().satisfied(satisfied).errorMessage(errorMessage).build();
    }
}

