/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.assistedinject.Assisted;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.plugins.map.geoip.GeoLocationInformation;
import org.graylog.plugins.map.geoip.MaxMindIpResolver;

public class MaxMindIpLocationResolver
extends MaxMindIpResolver<GeoLocationInformation> {
    @Inject
    public MaxMindIpLocationResolver(@Assisted Timer resolveTime, @Assisted String configPath, @Assisted boolean enabled) {
        super(resolveTime, configPath, enabled);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<GeoLocationInformation> doGetGeoIpData(InetAddress address) {
        try (Timer.Context ignored = this.getTimer();){
            CityResponse response = this.getCityResponse(address);
            Location location = response.getLocation();
            Country country = response.getCountry();
            City city = response.getCity();
            GeoLocationInformation info = GeoLocationInformation.create(location.getLatitude(), location.getLongitude(), country.getGeoNameId() == null ? "N/A" : country.getIsoCode(), country.getGeoNameId() == null ? "N/A" : country.getName(), city.getGeoNameId() == null ? "N/A" : city.getName(), "N/A", "N/A");
            Optional<GeoLocationInformation> optional = Optional.of(info);
            return optional;
        }
        catch (Exception e) {
            if (e instanceof AddressNotFoundException) return Optional.empty();
            LOG.debug("Could not get location from IP {}", (Object)address.getHostAddress(), (Object)e);
            this.lastError = e.getMessage();
            return Optional.empty();
        }
    }

    @VisibleForTesting
    Timer.Context getTimer() {
        return this.resolveTime.time();
    }

    @VisibleForTesting
    CityResponse getCityResponse(InetAddress address) throws IOException, GeoIp2Exception {
        return this.databaseReader.city(address);
    }
}

