/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip.processor;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.geoip.GeoIpResolverEngine;
import org.graylog.plugins.map.geoip.GeoIpVendorResolverService;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpProcessor
implements MessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpProcessor.class);
    private final ClusterConfigService clusterConfigService;
    private final ScheduledExecutorService scheduler;
    private final MetricRegistry metricRegistry;
    private final GeoIpVendorResolverService geoIpVendorResolverService;
    private final ServerStatus serverStatus;
    private final AtomicReference<GeoIpResolverEngine> filterEngine = new AtomicReference<Object>(null);

    @Inject
    public GeoIpProcessor(ClusterConfigService clusterConfigService, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, EventBus eventBus, MetricRegistry metricRegistry, GeoIpVendorResolverService geoIpVendorResolverService, ServerStatus serverStatus) {
        this.clusterConfigService = clusterConfigService;
        this.scheduler = scheduler;
        this.metricRegistry = metricRegistry;
        this.geoIpVendorResolverService = geoIpVendorResolverService;
        this.serverStatus = serverStatus;
        eventBus.register((Object)this);
    }

    @Override
    public Messages process(Messages messages) {
        if (this.filterEngine.get() == null) {
            try {
                this.serverStatus.awaitRunning();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("The GeoIpProcessor was interrupted while waiting for the Server to start up.");
                return messages;
            }
            this.reload();
        }
        for (Message message : messages) {
            this.filterEngine.get().filter(message);
        }
        return messages;
    }

    @Subscribe
    public void updateConfig(ClusterConfigChangedEvent event) {
        if (!GeoIpResolverConfig.class.getCanonicalName().equals(event.type())) {
            return;
        }
        this.scheduler.schedule(this::reload, 0L, TimeUnit.SECONDS);
    }

    private void reload() {
        GeoIpResolverConfig newConfig = this.clusterConfigService.getOrDefault(GeoIpResolverConfig.class, GeoIpResolverConfig.defaultConfig());
        LOG.debug("Updating GeoIP resolver engine - {}", (Object)newConfig);
        this.filterEngine.set(new GeoIpResolverEngine(this.geoIpVendorResolverService, newConfig, this.metricRegistry));
    }

    public static class Descriptor
    implements MessageProcessor.Descriptor {
        @Override
        public String name() {
            return "GeoIP Resolver";
        }

        @Override
        public String className() {
            return GeoIpProcessor.class.getCanonicalName();
        }
    }
}

