/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.engine.QuerySuggestionsService;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionRequest;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionResponse;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionEntryDTO;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionsDTO;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionsErrorDTO;
import org.graylog.plugins.views.search.rest.suggestions.SuggestionsRequestDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Suggestions")
@Path(value="/search/suggest")
public class SuggestionsResource
extends RestResource
implements PluginRestResource {
    public static final int SUGGESTIONS_COUNT_MAX = 100;
    private final PermittedStreams permittedStreams;
    private final QuerySuggestionsService querySuggestionsService;

    @Inject
    public SuggestionsResource(PermittedStreams permittedStreams, QuerySuggestionsService querySuggestionsService) {
        this.permittedStreams = permittedStreams;
        this.querySuggestionsService = querySuggestionsService;
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Suggest field value")
    @NoAuditEvent(value="Only suggesting field value for query, not changing any data")
    public SuggestionsDTO suggestFieldValue(@ApiParam(name="validationRequest") SuggestionsRequestDTO suggestionsRequest, @Context SearchUser searchUser) {
        SuggestionRequest req = SuggestionRequest.builder().field(suggestionsRequest.field()).input(suggestionsRequest.input()).streams(this.adaptStreams(suggestionsRequest.streams(), searchUser)).size(Math.min(suggestionsRequest.size(), 100)).timerange(Optional.ofNullable(suggestionsRequest.timerange()).orElse(this.defaultTimeRange())).build();
        SuggestionResponse res = this.querySuggestionsService.suggest(req);
        List<SuggestionEntryDTO> suggestions = res.suggestions().stream().map(s -> SuggestionEntryDTO.create(s.getValue(), s.getOccurrence())).collect(Collectors.toList());
        SuggestionsDTO.Builder suggestionsBuilder = SuggestionsDTO.builder(res.field(), res.input()).suggestions(suggestions).sumOtherDocsCount(res.sumOtherDocsCount());
        res.suggestionError().map(e -> SuggestionsErrorDTO.create(e.type(), e.reason())).ifPresent(suggestionsBuilder::error);
        return suggestionsBuilder.build();
    }

    private Set<String> adaptStreams(Set<String> streams, SearchUser searchUser) {
        if (streams == null || streams.isEmpty()) {
            return this.loadAllAllowedStreamsForUser(searchUser);
        }
        return streams.stream().filter(searchUser::canReadStream).collect(Collectors.toSet());
    }

    private RelativeRange defaultTimeRange() {
        try {
            return RelativeRange.create(300);
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableSet<String> loadAllAllowedStreamsForUser(SearchUser searchUser) {
        return this.permittedStreams.load(searchUser::canReadStream);
    }
}

