/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;
import org.graylog.plugins.views.search.validation.CollectingQueryParserTokenManager;
import org.graylog.plugins.views.search.validation.FixedBooleanQuery;
import org.graylog.plugins.views.search.validation.ImmutableToken;

public class TokenCollectingQueryParser
extends QueryParser {
    private final CollectingQueryParserTokenManager tokenManager;
    private final Set<ImmutableToken> processedTokens = new HashSet<ImmutableToken>();
    private final Map<Query, Collection<ImmutableToken>> tokenLookup = new IdentityHashMap<Query, Collection<ImmutableToken>>();

    public TokenCollectingQueryParser(String defaultFieldName, Analyzer analyzer) {
        this(new CollectingQueryParserTokenManager(), defaultFieldName, analyzer);
    }

    TokenCollectingQueryParser(CollectingQueryParserTokenManager collectingQueryParserTokenManager, String defaultFieldName, Analyzer analyzer) {
        super((QueryParserTokenManager)collectingQueryParserTokenManager);
        this.tokenManager = collectingQueryParserTokenManager;
        this.init(defaultFieldName, analyzer);
    }

    public List<ImmutableToken> getTokens() {
        return this.tokenManager.getTokens();
    }

    public Map<Query, Collection<ImmutableToken>> getTokenLookup() {
        return this.tokenLookup;
    }

    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
        return this.saveQueryLookupTokens(super.newFieldQuery(analyzer, field, queryText, quoted));
    }

    protected Query newPrefixQuery(Term prefix) {
        return this.saveQueryLookupTokens(super.newPrefixQuery(prefix));
    }

    protected Query newRegexpQuery(Term regexp) {
        return this.saveQueryLookupTokens(super.newRegexpQuery(regexp));
    }

    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        return this.saveQueryLookupTokens(super.newFuzzyQuery(term, minimumSimilarity, prefixLength));
    }

    protected Query newMatchAllDocsQuery() {
        return this.saveQueryLookupTokens(super.newMatchAllDocsQuery());
    }

    protected Query newWildcardQuery(Term t) {
        return this.saveQueryLookupTokens(super.newWildcardQuery(t));
    }

    protected Query newSynonymQuery(QueryBuilder.TermAndBoost[] terms) {
        return this.saveQueryLookupTokens(super.newSynonymQuery(terms));
    }

    protected Query newGraphSynonymQuery(Iterator<Query> queries) {
        return this.saveQueryLookupTokens(super.newGraphSynonymQuery(queries));
    }

    protected Query newTermQuery(Term term, float boost) {
        return this.saveQueryLookupTokens(super.newTermQuery(term, boost));
    }

    protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        return this.saveQueryLookupTokens(super.newRangeQuery(field, part1, part2, startInclusive, endInclusive));
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws ParseException {
        Query delegate = super.getBooleanQuery(clauses);
        return new FixedBooleanQuery((BooleanQuery)delegate);
    }

    private Query saveQueryLookupTokens(Query query) {
        Collection tokens = CollectionUtils.subtract(this.tokenManager.getTokens(), this.processedTokens);
        if (!this.tokenLookup.containsKey(query) && !tokens.isEmpty()) {
            this.processedTokens.addAll(tokens);
            this.tokenLookup.put(query, tokens);
        }
        return query;
    }
}

