/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.github.joschi.jadconfig.util.Size;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.shaded.kafka09.utils.FileLock;
import org.graylog2.Configuration;
import org.graylog2.bootstrap.preflight.PreflightCheck;
import org.graylog2.bootstrap.preflight.PreflightCheckException;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.FsStats;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskJournalPreflightCheck
implements PreflightCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DiskJournalPreflightCheck.class);
    private final Configuration configuration;
    private final FsProbe fsProbe;
    private final Path journalDirectory;
    private final Size journalMaxSize;

    @Inject
    public DiskJournalPreflightCheck(Configuration configuration, FsProbe fsProbe, @Named(value="message_journal_dir") Path journalDirectory, @Named(value="message_journal_max_size") Size journalMaxSize) {
        this.configuration = configuration;
        this.fsProbe = fsProbe;
        this.journalDirectory = journalDirectory;
        this.journalMaxSize = journalMaxSize;
    }

    @Override
    public void runCheck() throws PreflightCheckException {
        if (!this.configuration.isMessageJournalEnabled() || !this.configuration.getMessageJournalMode().equals("disk")) {
            return;
        }
        this.checkWritableJournalDir();
        this.checkJournalDirSizeAndType();
        this.checkJournalUnlocked();
    }

    private void checkJournalDirSizeAndType() {
        Map<String, FsStats.Filesystem> filesystems = this.fsProbe.fsStats().filesystems();
        FsStats.Filesystem journalFs = filesystems.get(this.journalDirectory.toAbsolutePath().toString());
        if (journalFs != null) {
            if (journalFs.available() > 0L && journalFs.available() < this.journalMaxSize.toBytes()) {
                throw new PreflightCheckException(StringUtils.f("Journal directory <%s> has not enough free space (%d MB) to contain 'message_journal_max_size = %d MB' ", this.journalDirectory.toAbsolutePath(), Size.bytes((long)journalFs.available()).toMegabytes(), this.journalMaxSize.toMegabytes()));
            }
            if (journalFs.typeName() != null && journalFs.typeName().equals("Network Disk")) {
                String message = StringUtils.f("Journal directory <%s> should not be on a network file system (%s)!", this.journalDirectory.toAbsolutePath(), journalFs.sysTypeName());
                LOG.warn(message);
            }
        } else {
            LOG.warn("Could not perform size check on journal directory <{}>", (Object)this.journalDirectory.toAbsolutePath());
        }
    }

    private void checkWritableJournalDir() {
        if (!Files.exists(this.journalDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.journalDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PreflightCheckException(StringUtils.f("Cannot create journal directory at <%s>", this.journalDirectory.toAbsolutePath()));
            }
        }
        if (!Files.isWritable(this.journalDirectory)) {
            throw new PreflightCheckException(StringUtils.f("Journal directory <%s> is not writable!", this.journalDirectory.toAbsolutePath()));
        }
    }

    private void checkJournalUnlocked() {
        File file = new File(this.journalDirectory.toFile(), ".lock");
        FileLock fileLock = null;
        try {
            fileLock = new FileLock(file);
            if (!fileLock.tryLock()) {
                throw new PreflightCheckException(StringUtils.f("The journal is already locked by another process. Try running fuser \"%s\" to find the PID.", file.getAbsolutePath()));
            }
        }
        finally {
            if (fileLock != null) {
                fileLock.unlock();
            }
        }
    }
}

