/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.constraints;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.util.Collection;
import java.util.Set;
import org.graylog2.contentpacks.constraints.ConstraintChecker;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.ConstraintCheckResult;
import org.graylog2.contentpacks.model.constraints.GraylogVersionConstraint;
import org.graylog2.plugin.Version;

public class GraylogVersionConstraintChecker
implements ConstraintChecker {
    private final Semver graylogVersion;

    public GraylogVersionConstraintChecker() {
        this(Version.CURRENT_CLASSPATH.toString());
    }

    @VisibleForTesting
    GraylogVersionConstraintChecker(String graylogVersion) {
        this(new Semver(graylogVersion));
    }

    @VisibleForTesting
    GraylogVersionConstraintChecker(Semver graylogVersion) {
        this.graylogVersion = graylogVersion;
    }

    @Override
    public Set<Constraint> ensureConstraints(Collection<Constraint> requestedConstraints) {
        ImmutableSet.Builder fulfilledConstraints = ImmutableSet.builder();
        for (Constraint constraint : requestedConstraints) {
            GraylogVersionConstraint versionConstraint;
            Requirement requiredVersion;
            if (!(constraint instanceof GraylogVersionConstraint) || !(requiredVersion = (versionConstraint = (GraylogVersionConstraint)constraint).version()).isSatisfiedBy(this.graylogVersion.withClearedSuffixAndBuild())) continue;
            fulfilledConstraints.add((Object)constraint);
        }
        return fulfilledConstraints.build();
    }

    @Override
    public Set<ConstraintCheckResult> checkConstraints(Collection<Constraint> requestedConstraints) {
        ImmutableSet.Builder fulfilledConstraints = ImmutableSet.builder();
        for (Constraint constraint : requestedConstraints) {
            if (!(constraint instanceof GraylogVersionConstraint)) continue;
            GraylogVersionConstraint versionConstraint = (GraylogVersionConstraint)constraint;
            Requirement requiredVersion = versionConstraint.version();
            ConstraintCheckResult constraintCheckResult = ConstraintCheckResult.create(versionConstraint, requiredVersion.isSatisfiedBy(this.graylogVersion.withClearedSuffixAndBuild()));
            fulfilledConstraints.add((Object)constraintCheckResult);
        }
        return fulfilledConstraints.build();
    }
}

