/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage;

import com.github.zafarkhaja.semver.Version;
import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.configuration.validators.SearchVersionRange;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.storage.AutoValue_SearchVersion;

@AutoValue
public abstract class SearchVersion {
    public abstract Distribution distribution();

    public abstract Version version();

    public SearchVersion major() {
        return SearchVersion.create(this.distribution(), Version.forIntegers((int)this.version().getMajorVersion(), (int)0, (int)0));
    }

    public boolean satisfies(Distribution distribution, String expression) {
        return this.distribution().equals((Object)distribution) && this.version().satisfies(expression);
    }

    public boolean satisfies(SearchVersionRange range) {
        return this.satisfies(range.distribution(), range.expression());
    }

    public boolean satisfies(Collection<SearchVersionRange> ranges) {
        for (SearchVersionRange range : ranges) {
            if (!this.satisfies(range)) continue;
            return true;
        }
        return false;
    }

    public static SearchVersion elasticsearch(String version) {
        return SearchVersion.elasticsearch(SearchVersion.parseVersion(version));
    }

    public static SearchVersion elasticsearch(Version version) {
        return SearchVersion.create(Distribution.ELASTICSEARCH, version);
    }

    public static SearchVersion elasticsearch(int major, int minor, int patch) {
        return SearchVersion.create(Distribution.ELASTICSEARCH, Version.forIntegers((int)major, (int)minor, (int)patch));
    }

    public String encode() {
        return String.format(Locale.ROOT, "%s:%s", this.distribution().name().toUpperCase(Locale.ROOT), this.version());
    }

    public static SearchVersion decode(String searchServerIdentifier) {
        String[] parts = searchServerIdentifier.split(":");
        if (parts.length == 2) {
            return SearchVersion.create(Distribution.valueOf(parts[0].toUpperCase(Locale.ROOT)), Version.valueOf((String)parts[1]));
        }
        return SearchVersion.elasticsearch(searchServerIdentifier);
    }

    public static SearchVersion create(@Nullable String distribution, Version version) {
        Distribution dst = Optional.ofNullable(distribution).map(String::trim).map(d -> d.toUpperCase(Locale.ROOT)).map(Distribution::valueOf).orElse(Distribution.ELASTICSEARCH);
        return new AutoValue_SearchVersion(dst, version);
    }

    public static SearchVersion create(Distribution distribution, Version version) {
        return new AutoValue_SearchVersion(distribution, version);
    }

    protected static Version parseVersion(String version) {
        try {
            return Version.valueOf((String)version);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Unable to parse Elasticsearch version: " + version, (Throwable)e);
        }
    }

    public String toString() {
        return (Object)((Object)this.distribution()) + ":" + this.version();
    }

    public boolean isElasticsearch() {
        return this.distribution().equals((Object)Distribution.ELASTICSEARCH);
    }

    public boolean isOpenSearch() {
        return this.distribution().equals((Object)Distribution.OPENSEARCH);
    }

    public static enum Distribution {
        ELASTICSEARCH("Elasticsearch"),
        OPENSEARCH("OpenSearch");

        private final String printName;

        private Distribution(String printName) {
            this.printName = printName;
        }

        public String toString() {
            return this.printName;
        }
    }
}

