/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ValidationMessageDTO;
import org.graylog.plugins.views.search.rest.ValidationRequestDTO;
import org.graylog.plugins.views.search.rest.ValidationResponseDTO;
import org.graylog.plugins.views.search.rest.ValidationStatusDTO;
import org.graylog.plugins.views.search.rest.ValidationTypeDTO;
import org.graylog.plugins.views.search.validation.QueryValidationService;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationResponse;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Validation")
@Path(value="/search/validate")
public class QueryValidationResource
extends RestResource
implements PluginRestResource {
    private final QueryValidationService queryValidationService;

    @Inject
    public QueryValidationResource(QueryValidationService queryValidationService) {
        this.queryValidationService = queryValidationService;
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate a search query")
    @NoAuditEvent(value="Only validating query structure, not changing any data")
    public ValidationResponseDTO validateQuery(@ApiParam(name="validationRequest") ValidationRequestDTO validationRequest, @Context SearchUser searchUser) {
        ValidationRequest.Builder q = ValidationRequest.Builder.builder().query(validationRequest.query()).timerange(validationRequest.timerange().orElse(this.defaultTimeRange())).streams((Set<String>)searchUser.streams().readableOrAllIfEmpty(validationRequest.streams())).parameters(this.resolveParameters(validationRequest));
        validationRequest.filter().ifPresent(q::filter);
        ValidationResponse response = this.queryValidationService.validate(q.build());
        return ValidationResponseDTO.create(this.toStatus(response.status()), this.toExplanations(response));
    }

    private ImmutableSet<Parameter> resolveParameters(ValidationRequestDTO validationRequest) {
        return (ImmutableSet)validationRequest.parameters().stream().map(param -> param.applyBindings((Map<String, Parameter.Binding>)validationRequest.parameterBindings())).collect(ImmutableSet.toImmutableSet());
    }

    private ValidationStatusDTO toStatus(ValidationStatus status) {
        ValidationStatusDTO statusDTO;
        switch (status) {
            case WARNING: {
                statusDTO = ValidationStatusDTO.WARNING;
                break;
            }
            case ERROR: {
                statusDTO = ValidationStatusDTO.ERROR;
                break;
            }
            default: {
                statusDTO = ValidationStatusDTO.OK;
            }
        }
        return statusDTO;
    }

    private List<ValidationMessageDTO> toExplanations(ValidationResponse response) {
        return response.explanations().stream().map(this::toExplanation).sorted(Comparator.comparing(ValidationMessageDTO::beginLine, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ValidationMessageDTO::beginColumn, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    private ValidationMessageDTO toExplanation(ValidationMessage message) {
        ValidationTypeDTO validationType = this.convert(message.validationType());
        return ValidationMessageDTO.create(validationType, message.beginLine(), message.beginColumn(), message.endLine(), message.endColumn(), message.errorMessage(), message.relatedProperty());
    }

    private ValidationTypeDTO convert(ValidationType validationType) {
        return ValidationTypeDTO.from(validationType);
    }

    private RelativeRange defaultTimeRange() {
        try {
            return RelativeRange.create(300);
        }
        catch (InvalidRangeParametersException e) {
            throw new RuntimeException(e);
        }
    }
}

