/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.glassfish.grizzly.http.server.Request;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;
import org.graylog2.rest.models.system.sessions.responses.SessionResponseFactory;
import org.graylog2.rest.models.system.sessions.responses.SessionValidationResponse;
import org.graylog2.rest.resources.system.CookieFactory;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.ActorAwareAuthenticationToken;
import org.graylog2.shared.security.ActorAwareAuthenticationTokenFactory;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;
import org.graylog2.shared.security.SessionCreator;
import org.graylog2.shared.security.ShiroAuthenticationFilter;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.shared.users.UserService;
import org.graylog2.utilities.IpSubnet;

@Path(value="/system/sessions")
@Api(value="System/Sessions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SessionsResource
extends RestResource {
    private final DefaultSecurityManager securityManager;
    private final ShiroAuthenticationFilter authenticationFilter;
    private final Set<IpSubnet> trustedSubnets;
    private final Request grizzlyRequest;
    private final SessionCreator sessionCreator;
    private final ActorAwareAuthenticationTokenFactory tokenFactory;
    private final SessionResponseFactory sessionResponseFactory;
    private final CookieFactory cookieFactory;
    private static final String USERNAME = "username";

    @Inject
    public SessionsResource(UserService userService, DefaultSecurityManager securityManager, ShiroAuthenticationFilter authenticationFilter, @Named(value="trusted_proxies") Set<IpSubnet> trustedSubnets, @Context Request grizzlyRequest, SessionCreator sessionCreator, ActorAwareAuthenticationTokenFactory tokenFactory, SessionResponseFactory sessionResponseFactory, CookieFactory cookieFactory) {
        this.cookieFactory = cookieFactory;
        this.userService = userService;
        this.securityManager = securityManager;
        this.authenticationFilter = authenticationFilter;
        this.trustedSubnets = trustedSubnets;
        this.grizzlyRequest = grizzlyRequest;
        this.sessionCreator = sessionCreator;
        this.tokenFactory = tokenFactory;
        this.sessionResponseFactory = sessionResponseFactory;
    }

    @POST
    @ApiOperation(value="Create a new session", notes="This request creates a new session for a user or reactivates an existing session: the equivalent of logging in.", response=SessionResponse.class)
    @NoAuditEvent(value="dispatches audit events in the method body")
    public Response newSession(@Context ContainerRequestContext requestContext, @ApiParam(name="Login request", value="Credentials. The default implementation requires presence of two properties: 'username' and 'password'. However a plugin may customize which kind of credentials are accepted and therefore expect different properties.", required=true) @NotNull JsonNode createRequest) {
        ActorAwareAuthenticationToken authToken;
        this.rejectServiceAccount(createRequest);
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (!(securityContext instanceof ShiroSecurityContext)) {
            throw new InternalServerErrorException("Unsupported SecurityContext class, this is a bug!");
        }
        ShiroSecurityContext shiroSecurityContext = (ShiroSecurityContext)securityContext;
        try {
            authToken = this.tokenFactory.forRequestBody(createRequest);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
        String sessionId = shiroSecurityContext.getUsername();
        String host = RestTools.getRemoteAddrFromRequest(this.grizzlyRequest, this.trustedSubnets);
        try {
            Optional<Session> session = this.sessionCreator.login(sessionId, host, authToken);
            if (session.isPresent()) {
                SessionResponse token = this.sessionResponseFactory.forSession(session.get());
                return Response.ok().entity((Object)token).cookie(new NewCookie[]{this.cookieFactory.createAuthenticationCookie(token, requestContext)}).build();
            }
            throw new NotAuthorizedException("Invalid credentials.", (Object)"Basic realm=\"Graylog Server session\"", new Object[0]);
        }
        catch (AuthenticationServiceUnavailableException e) {
            throw new ServiceUnavailableException("Authentication service unavailable");
        }
    }

    private void rejectServiceAccount(JsonNode createRequest) {
        User user;
        if (createRequest.has(USERNAME) && (user = this.userService.load(createRequest.get(USERNAME).asText())) != null && user.isServiceAccount()) {
            throw new BadRequestException("Cannot login with service account " + user.getName());
        }
    }

    @GET
    @ApiOperation(value="Validate an existing session", notes="Checks the session with the given ID: returns http status 204 (No Content) if session is valid.", code=204, response=SessionValidationResponse.class)
    public Response validateSession(@Context ContainerRequestContext requestContext) {
        try {
            this.authenticationFilter.filter(requestContext);
        }
        catch (IOException | NotAuthorizedException | LockedAccountException e) {
            return Response.ok((Object)SessionValidationResponse.invalid()).cookie(new NewCookie[]{this.cookieFactory.deleteAuthenticationCookie(requestContext)}).build();
        }
        Subject subject = this.getSubject();
        if (!subject.isAuthenticated()) {
            return Response.ok((Object)SessionValidationResponse.invalid()).cookie(new NewCookie[]{this.cookieFactory.deleteAuthenticationCookie(requestContext)}).build();
        }
        Session session = this.retrieveOrCreateSession(subject);
        User user = this.getCurrentUser();
        SessionResponse response = this.sessionResponseFactory.forSession(session);
        return Response.ok((Object)SessionValidationResponse.validWithNewSession(String.valueOf(session.getId()), String.valueOf(user.getName()))).cookie(new NewCookie[]{this.cookieFactory.createAuthenticationCookie(response, requestContext)}).build();
    }

    private Session retrieveOrCreateSession(Subject subject) {
        Session potentialSession = subject.getSession(false);
        if (this.needToCreateNewSession(potentialSession)) {
            String host = RestTools.getRemoteAddrFromRequest(this.grizzlyRequest, this.trustedSubnets);
            return this.sessionCreator.create(subject, host).orElseThrow(() -> new NotAuthorizedException("Invalid credentials.", (Object)"Basic realm=\"Graylog Server session\"", new Object[0]));
        }
        return potentialSession;
    }

    private boolean needToCreateNewSession(Session potentialSession) {
        return potentialSession == null && ShiroSecurityContext.isSessionCreationRequested();
    }

    @DELETE
    @ApiOperation(value="Terminate an existing session", notes="Destroys the session with the given ID: the equivalent of logging out.")
    @Path(value="/{sessionId}")
    @RequiresAuthentication
    @Deprecated
    @AuditEvent(type="server:session:delete")
    public Response terminateSessionWithId(@ApiParam(name="sessionId", required=true) @PathParam(value="sessionId") String sessionId, @Context ContainerRequestContext requestContext) {
        Subject subject = this.getSubject();
        this.securityManager.logout(subject);
        return Response.ok().cookie(new NewCookie[]{this.cookieFactory.deleteAuthenticationCookie(requestContext)}).build();
    }

    @DELETE
    @ApiOperation(value="Terminate an existing session", notes="Destroys the session with the given ID: the equivalent of logging out.")
    @RequiresAuthentication
    @AuditEvent(type="server:session:delete")
    public Response terminateSession(@Context ContainerRequestContext requestContext) {
        Subject subject = this.getSubject();
        this.securityManager.logout(subject);
        return Response.ok().cookie(new NewCookie[]{this.cookieFactory.deleteAuthenticationCookie(requestContext)}).build();
    }
}

