/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.net.InetAddresses;
import com.google.inject.assistedinject.Assisted;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.map.config.DatabaseType;
import org.graylog.plugins.map.geoip.;
import org.graylog.plugins.map.geoip.IPLocationDatabaseAdapter;
import org.graylog.plugins.map.geoip.IPinfoASN;
import org.graylog.plugins.map.geoip.IPinfoIPLocationDatabaseAdapter;
import org.graylog.plugins.map.geoip.IPinfoStandardLocation;
import org.graylog.plugins.map.geoip.MaxMindIPLocationDatabaseAdapter;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.plugin.utilities.FileInfo;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxmindDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MaxmindDataAdapter.class);
    public static final String NAME = "maxmind_geoip";
    private final Config config;
    private final AtomicReference<IPLocationDatabaseAdapter> databaseAdapter = new AtomicReference();
    private FileInfo fileInfo = FileInfo.empty();

    @Inject
    protected MaxmindDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
    }

    @Override
    protected void doStart() throws Exception {
        Path path = Paths.get(this.config.path(), new String[0]);
        this.fileInfo = FileInfo.forPath(path);
        if (!Files.isReadable(path)) {
            LOG.warn("Cannot read database file {}", (Object)this.config.path());
            this.setError(new IllegalStateException("Cannot read database file " + this.config.path()));
        } else {
            try {
                this.databaseAdapter.set(this.loadDatabaseAdapter(path.toFile()));
            }
            catch (Exception e) {
                LOG.warn("Unable to read data base file {}", (Object)this.config.path());
                this.setError(e);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        IPLocationDatabaseAdapter databaseReader = this.databaseAdapter.get();
        if (databaseReader != null) {
            databaseReader.close();
        }
    }

    @Override
    public Duration refreshInterval() {
        if (this.config.checkIntervalUnit() == null || this.config.checkInterval() == 0L) {
            return Duration.ZERO;
        }
        return Duration.millis((long)this.config.checkIntervalUnit().toMillis(this.config.checkInterval()));
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        try {
            FileInfo.Change databaseFileCheck = this.fileInfo.checkForChange();
            if (!databaseFileCheck.isChanged() && !this.getError().isPresent()) {
                return;
            }
            LOG.debug("MaxMind database file has changed, reloading it from {}", (Object)this.config.path());
            IPLocationDatabaseAdapter oldAdapter = this.databaseAdapter.get();
            try {
                this.databaseAdapter.set(this.loadDatabaseAdapter(Paths.get(this.config.path(), new String[0]).toFile()));
                cachePurge.purgeAll();
                if (oldAdapter != null) {
                    oldAdapter.close();
                }
                this.fileInfo = databaseFileCheck.fileInfo();
                this.clearError();
            }
            catch (IOException e) {
                LOG.warn("Unable to load changed database file, leaving old one intact. Error message: {}", (Object)e.getMessage());
                this.setError(e);
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Unable to refresh MaxMind database file: {}", (Object)iae.getMessage());
            this.setError(iae);
        }
    }

    private IPLocationDatabaseAdapter loadDatabaseAdapter(File file) throws IOException {
        switch (this.config.dbType()) {
            case MAXMIND_ASN: 
            case MAXMIND_CITY: 
            case MAXMIND_COUNTRY: {
                return new MaxMindIPLocationDatabaseAdapter(file);
            }
            case IPINFO_ASN: 
            case IPINFO_STANDARD_LOCATION: {
                return new IPinfoIPLocationDatabaseAdapter(file);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.config.dbType());
    }

    @Override
    protected LookupResult doGet(Object key) {
        InetAddress addr;
        if (key instanceof InetAddress) {
            addr = (InetAddress)key;
        } else {
            try {
                addr = InetAddresses.forString((String)key.toString());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to parse IP address, returning empty result.");
                return LookupResult.empty();
            }
        }
        IPLocationDatabaseAdapter reader = this.databaseAdapter.get();
        switch (this.config.dbType()) {
            case MAXMIND_CITY: {
                try {
                    String singleValue;
                    CityResponse city = reader.maxMindCity(addr);
                    if (city == null) {
                        LOG.debug("No city data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    Location location = city.getLocation();
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put("city", city.getCity());
                    map.put("continent", city.getContinent());
                    map.put("country", city.getCountry());
                    map.put("location", location);
                    map.put("postal", city.getPostal());
                    map.put("registered_country", city.getRegisteredCountry());
                    map.put("represented_country", city.getRepresentedCountry());
                    map.put("subdivisions", city.getSubdivisions());
                    map.put("traits", city.getTraits());
                    if (location == null || location.getLatitude() == null || location.getLongitude() == null) {
                        singleValue = null;
                    } else {
                        singleValue = location.getLatitude() + "," + location.getLongitude();
                        map.put("coordinates", singleValue);
                    }
                    return LookupResult.multi(singleValue, map);
                }
                catch (AddressNotFoundException nfe) {
                    LOG.debug("Unable to look up city data for IP address {}, returning empty result.", (Object)addr, (Object)nfe);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up city data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
            case MAXMIND_COUNTRY: {
                try {
                    CountryResponse countryResponse = reader.maxMindCountry(addr);
                    if (countryResponse == null) {
                        LOG.debug("No country data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    Country country = countryResponse.getCountry();
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put("continent", countryResponse.getContinent());
                    map.put("country", country);
                    map.put("registered_country", countryResponse.getRegisteredCountry());
                    map.put("represented_country", countryResponse.getRepresentedCountry());
                    map.put("traits", countryResponse.getTraits());
                    String singleValue = country == null ? null : country.getIsoCode();
                    return LookupResult.multi(singleValue, map);
                }
                catch (AddressNotFoundException nfe) {
                    LOG.debug("Unable to look up country data for IP address {}, returning empty result.", (Object)addr, (Object)nfe);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up country data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
            case MAXMIND_ASN: {
                try {
                    AsnResponse asn = reader.maxMindASN(addr);
                    if (asn == null) {
                        LOG.debug("No ASN data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    ImmutableMap map = ImmutableMap.of((Object)"as_number", (Object)asn.getAutonomousSystemNumber(), (Object)"as_organization", (Object)asn.getAutonomousSystemOrganization());
                    return LookupResult.multi(asn.getAutonomousSystemNumber(), (Map<Object, Object>)map);
                }
                catch (AddressNotFoundException nfe) {
                    LOG.debug("Unable to look up ASN data for IP address {}, returning empty result.", (Object)addr, (Object)nfe);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up ASN data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
            case IPINFO_ASN: {
                try {
                    IPinfoASN ipInfo = reader.ipInfoASN(addr);
                    if (ipInfo == null) {
                        LOG.debug("No IPinfo location data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    HashMap<String, Object> multiValue = new HashMap<String, Object>();
                    multiValue.put("asn", ipInfo.asn());
                    multiValue.put("asn_numeric", ipInfo.asnNumeric());
                    multiValue.put("name", ipInfo.name());
                    multiValue.put("domain", ipInfo.domain());
                    multiValue.put("type", ipInfo.type());
                    multiValue.put("route", ipInfo.route());
                    return LookupResult.multi(ipInfo.asnNumeric(), Collections.unmodifiableMap(multiValue));
                }
                catch (AddressNotFoundException e) {
                    LOG.debug("Unable to look up IPinfo ASN data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up IPinfo ASN data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
            case IPINFO_STANDARD_LOCATION: {
                try {
                    IPinfoStandardLocation ipInfo = reader.ipInfoStandardLocation(addr);
                    if (ipInfo == null) {
                        LOG.debug("No IPinfo location data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    HashMap<String, Object> multiValue = new HashMap<String, Object>();
                    multiValue.put("coordinates", ipInfo.coordinates());
                    multiValue.put("latitude", ipInfo.latitude());
                    multiValue.put("longitude", ipInfo.longitude());
                    multiValue.put("city", ipInfo.city());
                    multiValue.put("country", ipInfo.country());
                    multiValue.put("region", ipInfo.region());
                    multiValue.put("timezone", ipInfo.timezone());
                    multiValue.put("geoname_id", ipInfo.geoNameId());
                    return LookupResult.multi(ipInfo.coordinates(), Collections.unmodifiableMap(multiValue));
                }
                catch (AddressNotFoundException e) {
                    LOG.debug("Unable to look up IPinfo location data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up IPinfo location data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
        }
        return LookupResult.empty();
    }

    @Override
    public void set(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    void setDatabaseAdapter(IPLocationDatabaseAdapter databaseAdapter) {
        this.databaseAdapter.set(databaseAdapter);
    }

    @VisibleForTesting
    IPLocationDatabaseAdapter getDatabaseAdapter() {
        return this.databaseAdapter.get();
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_MaxmindDataAdapter_Config.Builder.class)
    @JsonTypeName(value="maxmind_geoip")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="path")
        @NotEmpty
        public abstract String path();

        @JsonProperty(value="database_type")
        @NotNull
        public abstract DatabaseType dbType();

        @JsonProperty(value="check_interval")
        @Min(value=0L)
        public abstract @Min(value=0L) long checkInterval();

        @Nullable
        @JsonProperty(value="check_interval_unit")
        public abstract TimeUnit checkIntervalUnit();

        public static Builder builder() {
            return new .AutoValue_MaxmindDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            Path path = Paths.get(this.path(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                errors.put((Object)"path", (Object)"The file does not exist.");
            } else if (!Files.isReadable(path)) {
                errors.put((Object)"path", (Object)"The file cannot be read.");
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="path")
            public abstract Builder path(String var1);

            @JsonProperty(value="database_type")
            public abstract Builder dbType(DatabaseType var1);

            @JsonProperty(value="check_interval")
            public abstract Builder checkInterval(long var1);

            @JsonProperty(value="check_interval_unit")
            public abstract Builder checkIntervalUnit(@Nullable TimeUnit var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(MaxmindDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(MaxmindDataAdapter.NAME).checkInterval(1L).checkIntervalUnit(TimeUnit.MINUTES).path("/etc/graylog/server/GeoLite2-City.mmdb").dbType(DatabaseType.MAXMIND_CITY).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<MaxmindDataAdapter> {
        @Override
        public MaxmindDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

