/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi;

import com.google.common.eventbus.EventBus;
import de.vandermeer.asciitable.AsciiTable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.SearchExecutor;
import org.graylog.plugins.views.search.events.SearchJobExecutionEvent;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.SearchJobDTO;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryParamsToFullRequestSpecificationMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.SearchRequestSpecToSearchMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.SearchTypeResultToTabularResponseMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseSchemaEntry;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="ScriptingApi", tags={"cloud"})
@Path(value="/search")
@Consumes(value={"application/json"})
@RequiresAuthentication
public class ScriptingApiResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptingApiResource.class);
    private final SearchExecutor searchExecutor;
    private final EventBus serverEventBus;
    private final SearchRequestSpecToSearchMapper searchCreator;
    private final SearchTypeResultToTabularResponseMapper responseCreator;
    private final QueryParamsToFullRequestSpecificationMapper queryParamsToFullRequestSpecificationMapper;

    @Inject
    public ScriptingApiResource(SearchExecutor searchExecutor, EventBus serverEventBus, SearchRequestSpecToSearchMapper searchCreator, SearchTypeResultToTabularResponseMapper responseCreator, QueryParamsToFullRequestSpecificationMapper queryParamsToFullRequestSpecificationMapper) {
        this.searchExecutor = searchExecutor;
        this.serverEventBus = serverEventBus;
        this.searchCreator = searchCreator;
        this.responseCreator = responseCreator;
        this.queryParamsToFullRequestSpecificationMapper = queryParamsToFullRequestSpecificationMapper;
    }

    @POST
    @ApiOperation(value="Execute aggregation specified by `searchRequestSpec`", response=TabularResponse.class)
    @Path(value="aggregate")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Produces(value={"application/json"})
    public TabularResponse executeQuery(@ApiParam(name="searchRequestSpec") @Valid SearchRequestSpec searchRequestSpec, @Context SearchUser searchUser) {
        SearchType.Result aggregationResult;
        Search search = this.searchCreator.mapToSearch(searchRequestSpec, searchUser);
        SearchJob searchJob = this.searchExecutor.execute(search, searchUser, ExecutionState.empty());
        this.postAuditEvent(searchJob);
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        QueryResult queryResult = searchJobDTO.results().get("scripting_api_temporary_query");
        if (queryResult != null && (aggregationResult = queryResult.searchTypes().get("scripting_api_temporary_pivot")) instanceof PivotResult) {
            PivotResult pivotResult = (PivotResult)aggregationResult;
            return this.responseCreator.mapToResponse(searchRequestSpec, pivotResult);
        }
        LOG.warn("Scripting API failed to obtain aggregation for input : " + searchRequestSpec);
        throw new NotFoundException("Scripting API failed to obtain aggregation for input : " + searchRequestSpec);
    }

    @POST
    @ApiOperation(value="Execute aggregation specified by `searchRequestSpec`", response=TabularResponse.class)
    @Path(value="aggregate")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Produces(value={"text/plain"})
    public String executeQueryAsciiOutput(@ApiParam(name="searchRequestSpec") @Valid SearchRequestSpec searchRequestSpec, @Context SearchUser searchUser) {
        TabularResponse response = this.executeQuery(searchRequestSpec, searchUser);
        AsciiTable at = new AsciiTable();
        at.getContext().setWidth(response.schema().size() * 25);
        at.addRule();
        at.addRow((Collection)response.schema().stream().map(ResponseSchemaEntry::name).collect(Collectors.toList()));
        at.addRule();
        response.datarows().forEach(arg_0 -> ((AsciiTable)at).addRow(arg_0));
        at.addRule();
        return at.render();
    }

    @GET
    @ApiOperation(value="Execute aggregation specified by query parameters", response=TabularResponse.class)
    @Path(value="aggregate")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Produces(value={"application/json"})
    public TabularResponse executeQuery(@QueryParam(value="query") String query, @QueryParam(value="streams") Set<String> streams, @QueryParam(value="timerange") String timerangeKeyword, @QueryParam(value="groups") List<String> groups, @QueryParam(value="metrics") List<String> metrics, @Context SearchUser searchUser) {
        SearchRequestSpec searchRequestSpec = this.queryParamsToFullRequestSpecificationMapper.simpleQueryParamsToFullRequestSpecification(query, streams, timerangeKeyword, groups, metrics);
        return this.executeQuery(searchRequestSpec, searchUser);
    }

    @GET
    @ApiOperation(value="Execute aggregation specified by query parameters", response=TabularResponse.class)
    @Path(value="aggregate")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    @Produces(value={"text/plain"})
    public String executeQueryAsciiOutput(@QueryParam(value="query") String query, @QueryParam(value="streams") Set<String> streams, @QueryParam(value="timerange") String timerangeKeyword, @QueryParam(value="groups") List<String> groups, @QueryParam(value="metrics") List<String> metrics, @Context SearchUser searchUser) {
        SearchRequestSpec searchRequestSpec = this.queryParamsToFullRequestSpecificationMapper.simpleQueryParamsToFullRequestSpecification(query, streams, timerangeKeyword, groups, metrics);
        return this.executeQueryAsciiOutput(searchRequestSpec, searchUser);
    }

    private void postAuditEvent(SearchJob searchJob) {
        SearchJobExecutionEvent searchJobExecutionEvent = SearchJobExecutionEvent.create(this.getCurrentUser(), searchJob, DateTime.now((DateTimeZone)DateTimeZone.UTC));
        this.serverEventBus.post((Object)searchJobExecutionEvent);
    }
}

