/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation.validators;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.graylog.plugins.views.search.engine.QueryPosition;
import org.graylog.plugins.views.search.validation.ImmutableToken;
import org.graylog.plugins.views.search.validation.QueryValidator;
import org.graylog.plugins.views.search.validation.ValidationContext;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;

@Singleton
public class InvalidOperatorsValidator
implements QueryValidator {
    private static final Set<String> INVALID_TOKENS = new HashSet<String>(Arrays.asList("and", "or", "not"));

    @Override
    public List<ValidationMessage> validate(ValidationContext context) {
        return context.query().tokens().stream().filter(this::isInvalidOperator).map(token -> {
            String errorMessage = String.format(Locale.ROOT, "Query contains invalid operator \"%s\". All AND / OR / NOT operators have to be written uppercase", token.image());
            return ValidationMessage.builder(ValidationStatus.WARNING, ValidationType.INVALID_OPERATOR).errorMessage(errorMessage).relatedProperty(token.image()).position(QueryPosition.from(token)).build();
        }).collect(Collectors.toList());
    }

    private boolean isInvalidOperator(ImmutableToken token) {
        return token.kind() == 20 && INVALID_TOKENS.contains(token.image());
    }
}

