/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.graylog.grn.GRN;
import org.graylog.security.;
import org.graylog.security.Capability;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GrantDTO {
    private static final String FIELD_ID = "id";
    static final String FIELD_GRANTEE = "grantee";
    static final String FIELD_CAPABILITY = "capability";
    public static final String FIELD_TARGET = "target";
    private static final String FIELD_CREATED_BY = "created_by";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_UPDATED_BY = "updated_by";
    private static final String FIELD_UPDATED_AT = "updated_at";
    private static final String FIELD_EXPIRES_AT = "expires_at";

    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="grantee")
    public abstract GRN grantee();

    @NotNull
    @JsonProperty(value="capability")
    public abstract Capability capability();

    @NotNull
    @JsonProperty(value="target")
    public abstract GRN target();

    @JsonProperty(value="created_by")
    public abstract String createdBy();

    @JsonProperty(value="created_at")
    public abstract ZonedDateTime createdAt();

    @JsonProperty(value="updated_by")
    public abstract String updatedBy();

    @JsonProperty(value="updated_at")
    public abstract ZonedDateTime updatedAt();

    @JsonProperty(value="expires_at")
    public abstract Optional<ZonedDateTime> expiresAt();

    public static GrantDTO of(GRN grantee, Capability capability, GRN target) {
        return GrantDTO.builder().grantee(grantee).capability(capability).target(target).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new .AutoValue_GrantDTO.Builder().createdBy("").createdAt(ZonedDateTime.now(ZoneOffset.UTC)).updatedBy("").updatedAt(ZonedDateTime.now(ZoneOffset.UTC));
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(@Nullable String var1);

        @JsonProperty(value="grantee")
        public abstract Builder grantee(GRN var1);

        @JsonProperty(value="capability")
        public abstract Builder capability(Capability var1);

        @JsonProperty(value="target")
        public abstract Builder target(GRN var1);

        @JsonProperty(value="created_by")
        public abstract Builder createdBy(String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(ZonedDateTime var1);

        @JsonProperty(value="updated_by")
        public abstract Builder updatedBy(String var1);

        @JsonProperty(value="updated_at")
        public abstract Builder updatedAt(ZonedDateTime var1);

        @JsonProperty(value="expires_at")
        public abstract Builder expiresAt(@Nullable ZonedDateTime var1);

        public abstract GrantDTO build();
    }
}

