/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.cluster.ClusterIdFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V19700101000000_GenerateClusterId
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V19700101000000_GenerateClusterId.class);
    private final ClusterConfigService clusterConfigService;
    private final ClusterIdFactory clusterIdFactory;

    @Inject
    public V19700101000000_GenerateClusterId(ClusterConfigService clusterConfigService, ClusterIdFactory clusterIdFactory) {
        this.clusterConfigService = clusterConfigService;
        this.clusterIdFactory = clusterIdFactory;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("1970-01-01T00:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(ClusterId.class) == null) {
            ClusterId clusterId = this.clusterIdFactory.create();
            this.clusterConfigService.write(clusterId);
            LOG.debug("Generated cluster ID {}", (Object)clusterId.clusterId());
        }
    }
}

