/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import one.util.streamex.EntryStream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220930095323_MigratePivotLimitsInSearches
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20220930095323_MigratePivotLimitsInSearches.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> searches;

    @Inject
    public V20220930095323_MigratePivotLimitsInSearches(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.searches = mongoConnection.getMongoDatabase().getCollection("searches");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-09-30T09:53:23Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        ArrayList pivotLimitMigrations = new ArrayList();
        for (Document document : this.searches.find()) {
            String searchId = ((ObjectId)document.get((Object)"_id", ObjectId.class)).toHexString();
            List queries = (List)document.get((Object)"queries", Collections.emptyList());
            EntryStream.of((List)queries).forEach(entry -> {
                Integer queryIndex = (Integer)entry.getKey();
                List searchTypes = (List)((Document)entry.getValue()).get((Object)"search_types", Collections.emptyList());
                ((EntryStream)EntryStream.of((List)searchTypes).filter(searchType -> "pivot".equals(((Document)searchType.getValue()).getString((Object)"type")))).forEach(searchTypeEntry -> {
                    Document searchType = (Document)searchTypeEntry.getValue();
                    Integer searchTypeIndex = (Integer)searchTypeEntry.getKey();
                    List rowPivots = (List)searchType.get((Object)"row_groups", Collections.emptyList());
                    Optional<Integer> maxRowPivotLimit = this.extractMaxLimit(rowPivots);
                    List columnPivots = (List)searchType.get((Object)"column_groups", Collections.emptyList());
                    Optional<Integer> maxColumnPivotLimit = this.extractMaxLimit(columnPivots);
                    if (searchTypeIndex != null && (maxRowPivotLimit.isPresent() || maxColumnPivotLimit.isPresent())) {
                        pivotLimitMigrations.add(new SearchPivotLimitMigration(searchId, queryIndex, searchTypeIndex, maxRowPivotLimit, maxColumnPivotLimit));
                    }
                });
            });
        }
        List operations = pivotLimitMigrations.stream().flatMap(pivotMigration -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            pivotMigration.rowLimit().ifPresent(rowLimit -> {
                builder.add(this.updateSearch(pivotMigration.searchId(), new Document("$set", (Object)new Document(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".row_limit", rowLimit))));
                builder.add(this.updateSearch(pivotMigration.searchId(), new Document("$unset", (Object)new Document(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".row_groups.$[].limit", (Object)1))));
            });
            pivotMigration.columnLimit().ifPresent(columnLimit -> {
                builder.add(this.updateSearch(pivotMigration.searchId(), new Document("$set", (Object)new Document(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".column_limit", columnLimit))));
                builder.add(this.updateSearch(pivotMigration.searchId(), new Document("$unset", (Object)new Document(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".column_groups.$[].limit", (Object)1))));
            });
            return builder.build().stream();
        }).collect(Collectors.toList());
        if (!operations.isEmpty()) {
            this.searches.bulkWrite(operations);
        }
        this.clusterConfigService.write(new MigrationCompleted(pivotLimitMigrations.size()));
    }

    private String pivotPath(SearchPivotLimitMigration pivotMigration) {
        return "queries." + pivotMigration.queryIndex() + ".search_types." + pivotMigration.searchTypeIndex();
    }

    private WriteModel<Document> updateSearch(String searchId, Document update) {
        return new UpdateOneModel((Bson)new Document("_id", (Object)new ObjectId(searchId)), (Bson)update, new UpdateOptions().upsert(false));
    }

    private Optional<Integer> extractMaxLimit(List<Document> groups) {
        return groups.stream().filter(group -> "values".equals(group.get((Object)"type"))).map(group -> group.getInteger((Object)"limit")).filter(Objects::nonNull).max(Integer::compare);
    }

    public record MigrationCompleted(@JsonProperty(value="migrated_search_types") Integer migratedSearchTypes) {
    }

    public record SearchPivotLimitMigration(String searchId, Integer queryIndex, Integer searchTypeIndex, Optional<Integer> rowLimit, Optional<Integer> columnLimit) {
    }
}

