/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.shutdown.GracefulShutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Path(value="/system/shutdown")
@Produces(value={"application/json"})
@Deprecated
public class SystemShutdownResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SystemShutdownResource.class);
    private final GracefulShutdown gracefulShutdown;
    private final ServerStatus serverStatus;

    @Inject
    public SystemShutdownResource(GracefulShutdown gracefulShutdown, ServerStatus serverStatus) {
        this.gracefulShutdown = gracefulShutdown;
        this.serverStatus = serverStatus;
    }

    @POST
    @Timed
    @Path(value="/shutdown")
    @AuditEvent(type="server:node_shutdown:initiate")
    @Deprecated
    public Response shutdown() {
        this.checkPermission("node:shutdown", this.serverStatus.getNodeId().toString());
        new Thread(this.gracefulShutdown).start();
        String msg = "Deprecated API endpoint /system/shutdown/shutdown was called. Shutting down the node via the API is discouraged in favor of using a service manager to control the server process.";
        LOG.warn("Deprecated API endpoint /system/shutdown/shutdown was called. Shutting down the node via the API is discouraged in favor of using a service manager to control the server process.");
        return Response.accepted((Object)ImmutableMap.of((Object)"message", (Object)"Deprecated API endpoint /system/shutdown/shutdown was called. Shutting down the node via the API is discouraged in favor of using a service manager to control the server process.")).build();
    }
}

