/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.google.auto.value.AutoValue;
import java.util.LinkedHashSet;
import org.graylog.plugins.views.search.export.AutoValue_SimpleMessageChunk;
import org.graylog.plugins.views.search.export.LinkedHashSetUtil;
import org.graylog.plugins.views.search.export.SimpleMessage;

@AutoValue
public abstract class SimpleMessageChunk {
    public static SimpleMessageChunk from(LinkedHashSet<String> fieldsInOrder, LinkedHashSet<SimpleMessage> messages) {
        return SimpleMessageChunk.builder().fieldsInOrder(fieldsInOrder).messages(messages).build();
    }

    public static SimpleMessageChunk from(LinkedHashSet<String> fieldsInOrder, SimpleMessage ... messages) {
        return SimpleMessageChunk.from(fieldsInOrder, LinkedHashSetUtil.linkedHashSetOf(messages));
    }

    public abstract LinkedHashSet<String> fieldsInOrder();

    public abstract LinkedHashSet<SimpleMessage> messages();

    public boolean isFirstChunk() {
        return this.chunkOrder().equals((Object)ChunkOrder.FIRST);
    }

    public boolean isLastChunk() {
        return this.chunkOrder().equals((Object)ChunkOrder.LAST);
    }

    public abstract ChunkOrder chunkOrder();

    public int size() {
        return this.messages().size();
    }

    public static Builder builder() {
        return Builder.create().chunkOrder(ChunkOrder.INTERMEDIATE);
    }

    public abstract Builder toBuilder();

    public Object[][] getAllValuesInOrder() {
        return (Object[][])this.messages().stream().map(this::valuesFrom).toArray(x$0 -> new Object[x$0][]);
    }

    private Object[] valuesFrom(SimpleMessage simpleMessage) {
        return this.fieldsInOrder().stream().map(simpleMessage::valueFor).toArray();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder fieldsInOrder(LinkedHashSet<String> var1);

        public abstract Builder messages(LinkedHashSet<SimpleMessage> var1);

        public abstract Builder chunkOrder(ChunkOrder var1);

        public static Builder create() {
            return new AutoValue_SimpleMessageChunk.Builder();
        }

        abstract SimpleMessageChunk autoBuild();

        public SimpleMessageChunk build() {
            return this.autoBuild();
        }
    }

    public static enum ChunkOrder {
        FIRST,
        INTERMEDIATE,
        LAST;

    }
}

