/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_CallResult;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_MasterResponse;
import org.graylog2.shared.rest.resources.AutoValue_ProxiedResource_NodeResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public abstract class ProxiedResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProxiedResource.class);
    private final String authenticationToken;
    protected final NodeService nodeService;
    protected final RemoteInterfaceProvider remoteInterfaceProvider;
    private final ExecutorService executor;

    protected ProxiedResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, ExecutorService executorService) {
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
        this.executor = executorService;
        this.authenticationToken = ProxiedResource.authenticationToken(httpHeaders);
    }

    public static String authenticationToken(HttpHeaders httpHeaders) {
        List authorizationHeader = httpHeaders.getRequestHeader("Authorization");
        if (authorizationHeader != null && !authorizationHeader.isEmpty()) {
            return (String)authorizationHeader.get(0);
        }
        Cookie authenticationCookie = (Cookie)httpHeaders.getCookies().get("authentication");
        if (authenticationCookie != null) {
            String sessionId = authenticationCookie.getValue();
            String credentials = sessionId + ":session";
            String base64Credentials = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            return "Basic " + base64Credentials;
        }
        return null;
    }

    @Nullable
    protected String getAuthenticationToken() {
        if (this.getSubject().isAuthenticated() && this.authenticationToken == null) {
            throw new NotAuthorizedException((Object)"Basic realm=\"Graylog Server\"", new Object[0]);
        }
        return this.authenticationToken;
    }

    @Deprecated
    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, Optional<RemoteCallResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider) {
        return this.getForAllNodes(fn, interfaceProvider, Function.identity());
    }

    @Deprecated
    protected <RemoteInterfaceType, FinalResponseType, RemoteCallResponseType> Map<String, Optional<FinalResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider, Function<RemoteCallResponseType, FinalResponseType> transformer) {
        Map futures = this.nodeService.allActive().keySet().stream().collect(Collectors.toMap(Function.identity(), node -> ((Optional)interfaceProvider.apply((String)node)).map(r -> this.executor.submit(() -> {
            Call call = (Call)fn.apply(r);
            try {
                Response response = call.execute();
                if (response.isSuccessful()) {
                    return Optional.of(transformer.apply(response.body()));
                }
                LOG.warn("Unable to call {} on node <{}>, result: {}", new Object[]{call.request().url(), node, response.message()});
                return Optional.empty();
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to call {} on node <{}>", new Object[]{call.request().url(), node, e});
                } else {
                    LOG.warn("Unable to call {} on node <{}>: {}", new Object[]{call.request().url(), node, e.getMessage()});
                }
                return Optional.empty();
            }
        })).orElse(CompletableFuture.completedFuture(Optional.empty()))));
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (Optional)((Future)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Couldn't retrieve future", (Throwable)e);
                return Optional.empty();
            }
        }));
    }

    protected <RemoteInterfaceType> Function<String, Optional<RemoteInterfaceType>> createRemoteInterfaceProvider(Class<RemoteInterfaceType> interfaceClass) {
        return nodeId -> {
            try {
                Node targetNode = this.nodeService.byNodeId((String)nodeId);
                return Optional.of(this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), interfaceClass));
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Node <" + nodeId + "> not found while trying to call " + interfaceClass.getName() + " on it.");
                return Optional.empty();
            }
        };
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, CallResult<RemoteCallResponseType>> requestOnAllNodes(Function<String, Optional<RemoteInterfaceType>> interfaceProvider, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn) {
        return this.requestOnAllNodes(interfaceProvider, fn, Function.identity());
    }

    protected <RemoteInterfaceType, RemoteCallResponseType, FinalResponseType> Map<String, CallResult<FinalResponseType>> requestOnAllNodes(Function<String, Optional<RemoteInterfaceType>> remoteInterfaceProvider, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceCallProvider, Function<RemoteCallResponseType, FinalResponseType> responseTransformer) {
        Map futures = this.nodeService.allActive().keySet().stream().collect(Collectors.toMap(Function.identity(), nodeId -> this.executor.submit(() -> {
            try {
                return CallResult.success(this.doNodeApiCall((String)nodeId, remoteInterfaceProvider, remoteInterfaceCallProvider, responseTransformer));
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Failed to call API on node {}, cause: {}", new Object[]{nodeId, e.getMessage(), e});
                } else {
                    LOG.warn("Failed to call API on node {}, cause: {}", nodeId, (Object)e.getMessage());
                }
                return CallResult.error(e.getMessage());
            }
        })));
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return (CallResult)((Future)entry.getValue()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Couldn't retrieve future", (Throwable)e);
                throw new RuntimeException(e);
            }
        }));
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> MasterResponse<RemoteCallResponseType> requestOnMaster(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Function<String, Optional<RemoteInterfaceType>> remoteInterfaceProvider) throws IOException {
        return MasterResponse.create(this.requestOnLeader(remoteInterfaceFunction, remoteInterfaceProvider));
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> NodeResponse<RemoteCallResponseType> requestOnLeader(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Function<String, Optional<RemoteInterfaceType>> remoteInterfaceProvider) throws IOException {
        Node leaderNode = this.nodeService.allActive().values().stream().filter(Node::isLeader).findFirst().orElseThrow(() -> new IllegalStateException("No active leader node found"));
        return this.doNodeApiCall(leaderNode.getNodeId(), remoteInterfaceProvider, remoteInterfaceFunction, Function.identity());
    }

    private <RemoteInterfaceType, RemoteCallResponseType, FinalResponseType> NodeResponse<FinalResponseType> doNodeApiCall(String nodeId, Function<String, Optional<RemoteInterfaceType>> remoteInterfaceProvider, Function<RemoteInterfaceType, Call<RemoteCallResponseType>> remoteInterfaceFunction, Function<RemoteCallResponseType, FinalResponseType> transformer) throws IOException {
        RemoteInterfaceType remoteInterfaceType = remoteInterfaceProvider.apply(nodeId).orElseThrow(() -> new IllegalStateException("Node " + nodeId + " not found"));
        Call<RemoteCallResponseType> call = remoteInterfaceFunction.apply(remoteInterfaceType);
        Response response = call.execute();
        byte[] errorBody = response.errorBody() == null ? null : response.errorBody().bytes();
        return NodeResponse.create(response.isSuccessful(), response.code(), transformer.apply(response.body()), errorBody);
    }

    @AutoValue
    public static abstract class NodeResponse<ResponseType> {
        @JsonProperty(value="success")
        public abstract boolean isSuccess();

        @JsonProperty(value="code")
        public abstract int code();

        @JsonProperty(value="entity")
        public abstract Optional<ResponseType> entity();

        public abstract Optional<byte[]> error();

        public Object body() {
            return this.entity().isPresent() ? this.entity().get() : this.error().orElse(null);
        }

        @JsonProperty(value="error_text")
        @Nullable
        public String errorText() {
            return this.error().map(bytes -> new String((byte[])bytes, Charset.defaultCharset())).orElse(null);
        }

        public static <ResponseType> NodeResponse<ResponseType> create(boolean isSuccess, int code, @Nullable ResponseType entity, @Nullable byte[] error) {
            return new AutoValue_ProxiedResource_NodeResponse<ResponseType>(isSuccess, code, Optional.ofNullable(entity), Optional.ofNullable(error));
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class MasterResponse<ResponseType> {
        public abstract boolean isSuccess();

        public abstract int code();

        public abstract Optional<ResponseType> entity();

        public abstract Optional<byte[]> error();

        public Object body() {
            return this.entity().isPresent() ? this.entity().get() : this.error().orElse(null);
        }

        public static <ResponseType> MasterResponse<ResponseType> create(NodeResponse<ResponseType> nodeResponse) {
            return new AutoValue_ProxiedResource_MasterResponse<ResponseType>(nodeResponse.isSuccess(), nodeResponse.code(), nodeResponse.entity(), nodeResponse.error());
        }
    }

    @AutoValue
    public static abstract class CallResult<ResponseType> {
        @JsonProperty(value="call_executed")
        public abstract boolean isCallExecuted();

        @JsonProperty(value="server_error_message")
        @Nullable
        public abstract String serverErrorMessage();

        @JsonProperty(value="response")
        @Nullable
        public abstract NodeResponse<ResponseType> response();

        public static <ResponseType> CallResult<ResponseType> success(@Nonnull NodeResponse<ResponseType> response) {
            return new AutoValue_ProxiedResource_CallResult<ResponseType>(true, null, response);
        }

        public static <ResponseType> CallResult<ResponseType> error(@Nonnull String serverErrorMessage) {
            return new AutoValue_ProxiedResource_CallResult(false, serverErrorMessage, null);
        }
    }
}

