/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.utilities;

import java.util.Locale;

public final class StringUtils {
    private StringUtils() {
    }

    public static String f(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static String humanReadableByteCount(long bytes) {
        String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};
        int base = 1024;
        if (bytes < 1024L) {
            return bytes + " " + units[0];
        }
        int exponent = (int)(Math.log(bytes) / Math.log(1024.0));
        String unit = units[exponent];
        return StringUtils.f("%.1f %s", (double)bytes / Math.pow(1024.0, exponent), unit);
    }
}

