/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;

public class V20191204000000_RemoveLegacyViewsPermissions
extends Migration {
    private final MongoDatabase mongoDatabase;

    @Inject
    public V20191204000000_RemoveLegacyViewsPermissions(MongoConnection mongoConnection) {
        this.mongoDatabase = mongoConnection.getMongoDatabase();
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-12-04T00:00:00Z");
    }

    @Override
    public void upgrade() {
        MongoCollection roles = this.mongoDatabase.getCollection("roles");
        Document viewsUserRole = (Document)roles.findOneAndDelete(Filters.eq((String)"name", (Object)"Views User"));
        if (viewsUserRole != null) {
            this.removeRoleFromUsers(viewsUserRole);
        }
    }

    private void removeRoleFromUsers(Document viewsUserRole) {
        MongoCollection users = this.mongoDatabase.getCollection("users");
        users.updateMany((Bson)new Document().append("roles", viewsUserRole.get((Object)"_id")), (Bson)new Document().append("$pull", (Object)new Document().append("roles", viewsUserRole.get((Object)"_id"))));
    }
}

