/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.elasticsearch.QueryParam;
import org.graylog.plugins.views.search.validation.SubstringMultilinePosition;

public class QueryStringParser {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$([a-zA-Z_]\\w*)\\$");

    public QueryMetadata parse(String queryString) {
        if (Strings.isNullOrEmpty((String)queryString)) {
            return QueryMetadata.empty();
        }
        LinkedHashMap positions = new LinkedHashMap();
        String[] lines = queryString.split("\n");
        for (int line = 0; line < lines.length; ++line) {
            String currentLine = lines[line];
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(currentLine);
            while (matcher.find()) {
                String name = matcher.group(1);
                if (!positions.containsKey(name)) {
                    positions.put(name, new ArrayList());
                }
                ((List)positions.get(name)).add(SubstringMultilinePosition.create(line + 1, matcher.start(), matcher.end()));
            }
        }
        ImmutableSet params = (ImmutableSet)positions.entrySet().stream().map(entry -> QueryParam.create((String)entry.getKey(), (List)entry.getValue())).collect(ImmutableSet.toImmutableSet());
        return QueryMetadata.builder().usedParameters((Set<QueryParam>)params).build();
    }
}

