/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.GroupingToBucketSpecMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MetricsToSeriesSpecMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Sortable;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;

public class AggregationSpecToPivotMapper
implements Function<SearchRequestSpec, Pivot> {
    public static final String PIVOT_ID = "scripting_api_temporary_pivot";
    private final GroupingToBucketSpecMapper rowGroupCreator;
    private final MetricsToSeriesSpecMapper seriesCreator;

    @Inject
    public AggregationSpecToPivotMapper(GroupingToBucketSpecMapper rowGroupCreator, MetricsToSeriesSpecMapper seriesCreator) {
        this.rowGroupCreator = rowGroupCreator;
        this.seriesCreator = seriesCreator;
    }

    @Override
    public Pivot apply(SearchRequestSpec aggregationSpec) {
        Pivot.Builder pivotBuilder = Pivot.builder().id(PIVOT_ID).rollup(false).rowGroups(aggregationSpec.groupings().stream().map(this.rowGroupCreator).collect(Collectors.toList())).series(aggregationSpec.metrics().stream().map(this.seriesCreator).collect(Collectors.toList()));
        if (aggregationSpec.hasCustomSort()) {
            pivotBuilder.sort(this.getSortSpecs(aggregationSpec.metrics()));
        }
        return pivotBuilder.build();
    }

    private List<SortSpec> getSortSpecs(Collection<? extends Sortable> groupings) {
        return groupings.stream().filter(sortable -> sortable.sort() != null).map(sortable -> {
            if (sortable instanceof Metric) {
                return SeriesSort.create(sortable.sortColumnName(), sortable.sort());
            }
            return PivotSort.create(sortable.sortColumnName(), sortable.sort());
        }).collect(Collectors.toList());
    }
}

