/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import org.graylog.plugins.views.search.rest.scriptingapi.parsing.MetricParser;
import org.graylog.plugins.views.search.rest.scriptingapi.parsing.TimerangeParser;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Grouping;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;

public class QueryParamsToFullRequestSpecificationMapper {
    private final MetricParser metricParser;
    private final TimerangeParser timerangeParser;

    @Inject
    public QueryParamsToFullRequestSpecificationMapper(TimerangeParser timerangeParser, MetricParser metricParser) {
        this.timerangeParser = timerangeParser;
        this.metricParser = metricParser;
    }

    public SearchRequestSpec simpleQueryParamsToFullRequestSpecification(String query, Set<String> streams, String timerangeKeyword, List<String> groups, List<String> metrics) {
        if (groups == null || groups.isEmpty()) {
            throw new BadRequestException("At least one grouping has to be provided!");
        }
        if (metrics == null || metrics.isEmpty()) {
            metrics = List.of("count:");
        }
        if (!metrics.stream().allMatch(m -> m.contains(":"))) {
            throw new BadRequestException("All metrics need to be defined as \"function\":\"field_name\"");
        }
        return new SearchRequestSpec(query, streams, this.timerangeParser.parseTimeRange(timerangeKeyword), groups.stream().map(Grouping::new).collect(Collectors.toList()), metrics.stream().map(this.metricParser::parseMetric).collect(Collectors.toList()));
    }
}

